<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSONotificationType StructType
 * @subpackage Structs
 */
class PSONotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \StructType\EmailDetailsType
     */
    public $EMail;
    /**
     * Constructor method for PSONotificationType
     * @uses PSONotificationType::setNotificationCode()
     * @uses PSONotificationType::setEMail()
     * @param string $notificationCode
     * @param \StructType\EmailDetailsType $eMail
     */
    public function __construct($notificationCode = null, \StructType\EmailDetailsType $eMail = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \StructType\PSONotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \StructType\EmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \StructType\EmailDetailsType $eMail
     * @return \StructType\PSONotificationType
     */
    public function setEMail(\StructType\EmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
}
