<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSOCODType StructType
 * @subpackage Structs
 */
class PSOCODType extends AbstractStructBase
{
    /**
     * The CODFundsCode
     * @var string
     */
    public $CODFundsCode;
    /**
     * The CODAmount
     * @var \StructType\CurrencyMonetaryType
     */
    public $CODAmount;
    /**
     * Constructor method for PSOCODType
     * @uses PSOCODType::setCODFundsCode()
     * @uses PSOCODType::setCODAmount()
     * @param string $cODFundsCode
     * @param \StructType\CurrencyMonetaryType $cODAmount
     */
    public function __construct($cODFundsCode = null, \StructType\CurrencyMonetaryType $cODAmount = null)
    {
        $this
            ->setCODFundsCode($cODFundsCode)
            ->setCODAmount($cODAmount);
    }
    /**
     * Get CODFundsCode value
     * @return string|null
     */
    public function getCODFundsCode()
    {
        return $this->CODFundsCode;
    }
    /**
     * Set CODFundsCode value
     * @param string $cODFundsCode
     * @return \StructType\PSOCODType
     */
    public function setCODFundsCode($cODFundsCode = null)
    {
        // validation for constraint: string
        if (!is_null($cODFundsCode) && !is_string($cODFundsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODFundsCode, true), gettype($cODFundsCode)), __LINE__);
        }
        $this->CODFundsCode = $cODFundsCode;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return \StructType\CurrencyMonetaryType|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param \StructType\CurrencyMonetaryType $cODAmount
     * @return \StructType\PSOCODType
     */
    public function setCODAmount(\StructType\CurrencyMonetaryType $cODAmount = null)
    {
        $this->CODAmount = $cODAmount;
        return $this;
    }
}
