<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherChargesType StructType
 * @subpackage Structs
 */
class OtherChargesType extends AbstractStructBase
{
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * Constructor method for OtherChargesType
     * @uses OtherChargesType::setMonetaryValue()
     * @uses OtherChargesType::setDescription()
     * @param string $monetaryValue
     * @param string $description
     */
    public function __construct($monetaryValue = null, $description = null)
    {
        $this
            ->setMonetaryValue($monetaryValue)
            ->setDescription($description);
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \StructType\OtherChargesType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OtherChargesType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
