<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedRateChargesType StructType
 * @subpackage Structs
 */
class NegotiatedRateChargesType extends AbstractStructBase
{
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $TotalCharge;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $TotalChargesWithTaxes;
    /**
     * Constructor method for NegotiatedRateChargesType
     * @uses NegotiatedRateChargesType::setItemizedCharges()
     * @uses NegotiatedRateChargesType::setTaxCharges()
     * @uses NegotiatedRateChargesType::setTotalCharge()
     * @uses NegotiatedRateChargesType::setTotalChargesWithTaxes()
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @param \StructType\TaxChargeType[] $taxCharges
     * @param \StructType\ShipChargeType $totalCharge
     * @param \StructType\ShipChargeType $totalChargesWithTaxes
     */
    public function __construct(array $itemizedCharges = array(), array $taxCharges = array(), \StructType\ShipChargeType $totalCharge = null, \StructType\ShipChargeType $totalChargesWithTaxes = null)
    {
        $this
            ->setItemizedCharges($itemizedCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharge($totalCharge)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes);
    }
    /**
     * Get ItemizedCharges value
     * @return \StructType\ShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negotiatedRateChargesTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$negotiatedRateChargesTypeItemizedChargesItem instanceof \StructType\ShipChargeType) {
                $invalidValues[] = is_object($negotiatedRateChargesTypeItemizedChargesItem) ? get_class($negotiatedRateChargesTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($negotiatedRateChargesTypeItemizedChargesItem), var_export($negotiatedRateChargesTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @return \StructType\NegotiatedRateChargesType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType $item
     * @return \StructType\NegotiatedRateChargesType
     */
    public function addToItemizedCharges(\StructType\ShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \StructType\TaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negotiatedRateChargesTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$negotiatedRateChargesTypeTaxChargesItem instanceof \StructType\TaxChargeType) {
                $invalidValues[] = is_object($negotiatedRateChargesTypeTaxChargesItem) ? get_class($negotiatedRateChargesTypeTaxChargesItem) : sprintf('%s(%s)', gettype($negotiatedRateChargesTypeTaxChargesItem), var_export($negotiatedRateChargesTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \StructType\TaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxChargeType[] $taxCharges
     * @return \StructType\NegotiatedRateChargesType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxChargeType $item
     * @return \StructType\NegotiatedRateChargesType
     */
    public function addToTaxCharges(\StructType\TaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \StructType\TaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \StructType\ShipChargeType|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \StructType\ShipChargeType $totalCharge
     * @return \StructType\NegotiatedRateChargesType
     */
    public function setTotalCharge(\StructType\ShipChargeType $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \StructType\ShipChargeType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \StructType\ShipChargeType $totalChargesWithTaxes
     * @return \StructType\NegotiatedRateChargesType
     */
    public function setTotalChargesWithTaxes(\StructType\ShipChargeType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
}
