<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocaleType StructType
 * @subpackage Structs
 */
class LocaleType extends AbstractStructBase
{
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Dialect
     * @var string
     */
    public $Dialect;
    /**
     * Constructor method for LocaleType
     * @uses LocaleType::setLanguage()
     * @uses LocaleType::setDialect()
     * @param string $language
     * @param string $dialect
     */
    public function __construct($language = null, $dialect = null)
    {
        $this
            ->setLanguage($language)
            ->setDialect($dialect);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\LocaleType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Dialect value
     * @return string|null
     */
    public function getDialect()
    {
        return $this->Dialect;
    }
    /**
     * Set Dialect value
     * @param string $dialect
     * @return \StructType\LocaleType
     */
    public function setDialect($dialect = null)
    {
        // validation for constraint: string
        if (!is_null($dialect) && !is_string($dialect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dialect, true), gettype($dialect)), __LINE__);
        }
        $this->Dialect = $dialect;
        return $this;
    }
}
