<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageForUPSPremiumCareType StructType
 * @subpackage Structs
 */
class LanguageForUPSPremiumCareType extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for LanguageForUPSPremiumCareType
     * @uses LanguageForUPSPremiumCareType::setLanguage()
     * @param string[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get Language value
     * @return string[]|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $languageForUPSPremiumCareTypeLanguageItem) {
            // validation for constraint: itemType
            if (!is_string($languageForUPSPremiumCareTypeLanguageItem)) {
                $invalidValues[] = is_object($languageForUPSPremiumCareTypeLanguageItem) ? get_class($languageForUPSPremiumCareTypeLanguageItem) : sprintf('%s(%s)', gettype($languageForUPSPremiumCareTypeLanguageItem), var_export($languageForUPSPremiumCareTypeLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\LanguageForUPSPremiumCareType
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($language) && count($language) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LanguageForUPSPremiumCareType
     */
    public function addToLanguage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Language) && count($this->Language) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Language)), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
}
