<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelDeliveryType StructType
 * @subpackage Structs
 */
class LabelDeliveryType extends AbstractStructBase
{
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailDetailsType
     */
    public $EMail;
    /**
     * The LabelLinksIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelLinksIndicator;
    /**
     * Constructor method for LabelDeliveryType
     * @uses LabelDeliveryType::setEMail()
     * @uses LabelDeliveryType::setLabelLinksIndicator()
     * @param \StructType\EmailDetailsType $eMail
     * @param string $labelLinksIndicator
     */
    public function __construct(\StructType\EmailDetailsType $eMail = null, $labelLinksIndicator = null)
    {
        $this
            ->setEMail($eMail)
            ->setLabelLinksIndicator($labelLinksIndicator);
    }
    /**
     * Get EMail value
     * @return \StructType\EmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \StructType\EmailDetailsType $eMail
     * @return \StructType\LabelDeliveryType
     */
    public function setEMail(\StructType\EmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get LabelLinksIndicator value
     * @return string|null
     */
    public function getLabelLinksIndicator()
    {
        return $this->LabelLinksIndicator;
    }
    /**
     * Set LabelLinksIndicator value
     * @param string $labelLinksIndicator
     * @return \StructType\LabelDeliveryType
     */
    public function setLabelLinksIndicator($labelLinksIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($labelLinksIndicator) && !is_string($labelLinksIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelLinksIndicator, true), gettype($labelLinksIndicator)), __LINE__);
        }
        $this->LabelLinksIndicator = $labelLinksIndicator;
        return $this;
    }
}
