<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightShipmentInformationType StructType
 * @subpackage Structs
 */
class FreightShipmentInformationType extends AbstractStructBase
{
    /**
     * The FreightDensityInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FreightDensityInfoType
     */
    public $FreightDensityInfo;
    /**
     * The DensityEligibleIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DensityEligibleIndicator;
    /**
     * Constructor method for FreightShipmentInformationType
     * @uses FreightShipmentInformationType::setFreightDensityInfo()
     * @uses FreightShipmentInformationType::setDensityEligibleIndicator()
     * @param \StructType\FreightDensityInfoType $freightDensityInfo
     * @param string $densityEligibleIndicator
     */
    public function __construct(\StructType\FreightDensityInfoType $freightDensityInfo = null, $densityEligibleIndicator = null)
    {
        $this
            ->setFreightDensityInfo($freightDensityInfo)
            ->setDensityEligibleIndicator($densityEligibleIndicator);
    }
    /**
     * Get FreightDensityInfo value
     * @return \StructType\FreightDensityInfoType|null
     */
    public function getFreightDensityInfo()
    {
        return $this->FreightDensityInfo;
    }
    /**
     * Set FreightDensityInfo value
     * @param \StructType\FreightDensityInfoType $freightDensityInfo
     * @return \StructType\FreightShipmentInformationType
     */
    public function setFreightDensityInfo(\StructType\FreightDensityInfoType $freightDensityInfo = null)
    {
        $this->FreightDensityInfo = $freightDensityInfo;
        return $this;
    }
    /**
     * Get DensityEligibleIndicator value
     * @return string|null
     */
    public function getDensityEligibleIndicator()
    {
        return $this->DensityEligibleIndicator;
    }
    /**
     * Set DensityEligibleIndicator value
     * @param string $densityEligibleIndicator
     * @return \StructType\FreightShipmentInformationType
     */
    public function setDensityEligibleIndicator($densityEligibleIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($densityEligibleIndicator) && !is_string($densityEligibleIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($densityEligibleIndicator, true), gettype($densityEligibleIndicator)), __LINE__);
        }
        $this->DensityEligibleIndicator = $densityEligibleIndicator;
        return $this;
    }
}
