<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormImageType StructType
 * @subpackage Structs
 */
class FormImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImageFormatType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for FormImageType
     * @uses FormImageType::setImageFormat()
     * @uses FormImageType::setGraphicImage()
     * @param \StructType\ImageFormatType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\StructType\ImageFormatType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \StructType\ImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \StructType\ImageFormatType $imageFormat
     * @return \StructType\FormImageType
     */
    public function setImageFormat(\StructType\ImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \StructType\FormImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
