<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedDutiesAndTaxesType StructType
 * @subpackage Structs
 */
class EstimatedDutiesAndTaxesType extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * The BrokerageFees
     * @var \StructType\BrokerageFeesType
     */
    public $BrokerageFees;
    /**
     * Constructor method for EstimatedDutiesAndTaxesType
     * @uses EstimatedDutiesAndTaxesType::setCurrencyCode()
     * @uses EstimatedDutiesAndTaxesType::setMonetaryValue()
     * @uses EstimatedDutiesAndTaxesType::setBrokerageFees()
     * @param string $currencyCode
     * @param string $monetaryValue
     * @param \StructType\BrokerageFeesType $brokerageFees
     */
    public function __construct($currencyCode = null, $monetaryValue = null, \StructType\BrokerageFeesType $brokerageFees = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setMonetaryValue($monetaryValue)
            ->setBrokerageFees($brokerageFees);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\EstimatedDutiesAndTaxesType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \StructType\EstimatedDutiesAndTaxesType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
    /**
     * Get BrokerageFees value
     * @return \StructType\BrokerageFeesType|null
     */
    public function getBrokerageFees()
    {
        return $this->BrokerageFees;
    }
    /**
     * Set BrokerageFees value
     * @param \StructType\BrokerageFeesType $brokerageFees
     * @return \StructType\EstimatedDutiesAndTaxesType
     */
    public function setBrokerageFees(\StructType\BrokerageFeesType $brokerageFees = null)
    {
        $this->BrokerageFees = $brokerageFees;
        return $this;
    }
}
