<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailType StructType
 * @subpackage Structs
 */
class DetailType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for DetailType
     * @uses DetailType::setCode()
     * @uses DetailType::setDescription()
     * @uses DetailType::setElementLevelInformation()
     * @param string $code
     * @param string $description
     * @param \StructType\ElementLevelInformationType $elementLevelInformation
     */
    public function __construct($code = null, $description = null, \StructType\ElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DetailType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DetailType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \StructType\ElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \StructType\ElementLevelInformationType $elementLevelInformation
     * @return \StructType\DetailType
     */
    public function setElementLevelInformation(\StructType\ElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
