<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType StructType
 * @subpackage Structs
 */
class CompanyInfoType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The AttentionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttentionName;
    /**
     * The CompanyDisplayableName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyDisplayableName;
    /**
     * The TaxIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The TaxIDType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxIDCodeDescType
     */
    public $TaxIDType;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipPhoneType
     */
    public $Phone;
    /**
     * Constructor method for CompanyInfoType
     * @uses CompanyInfoType::setName()
     * @uses CompanyInfoType::setAttentionName()
     * @uses CompanyInfoType::setCompanyDisplayableName()
     * @uses CompanyInfoType::setTaxIdentificationNumber()
     * @uses CompanyInfoType::setTaxIDType()
     * @uses CompanyInfoType::setPhone()
     * @param string $name
     * @param string $attentionName
     * @param string $companyDisplayableName
     * @param string $taxIdentificationNumber
     * @param \StructType\TaxIDCodeDescType $taxIDType
     * @param \StructType\ShipPhoneType $phone
     */
    public function __construct($name = null, $attentionName = null, $companyDisplayableName = null, $taxIdentificationNumber = null, \StructType\TaxIDCodeDescType $taxIDType = null, \StructType\ShipPhoneType $phone = null)
    {
        $this
            ->setName($name)
            ->setAttentionName($attentionName)
            ->setCompanyDisplayableName($companyDisplayableName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setTaxIDType($taxIDType)
            ->setPhone($phone);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CompanyInfoType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \StructType\CompanyInfoType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get CompanyDisplayableName value
     * @return string|null
     */
    public function getCompanyDisplayableName()
    {
        return $this->CompanyDisplayableName;
    }
    /**
     * Set CompanyDisplayableName value
     * @param string $companyDisplayableName
     * @return \StructType\CompanyInfoType
     */
    public function setCompanyDisplayableName($companyDisplayableName = null)
    {
        // validation for constraint: string
        if (!is_null($companyDisplayableName) && !is_string($companyDisplayableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyDisplayableName, true), gettype($companyDisplayableName)), __LINE__);
        }
        $this->CompanyDisplayableName = $companyDisplayableName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \StructType\CompanyInfoType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get TaxIDType value
     * @return \StructType\TaxIDCodeDescType|null
     */
    public function getTaxIDType()
    {
        return $this->TaxIDType;
    }
    /**
     * Set TaxIDType value
     * @param \StructType\TaxIDCodeDescType $taxIDType
     * @return \StructType\CompanyInfoType
     */
    public function setTaxIDType(\StructType\TaxIDCodeDescType $taxIDType = null)
    {
        $this->TaxIDType = $taxIDType;
        return $this;
    }
    /**
     * Get Phone value
     * @return \StructType\ShipPhoneType|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \StructType\ShipPhoneType $phone
     * @return \StructType\CompanyInfoType
     */
    public function setPhone(\StructType\ShipPhoneType $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
}
