<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CN22FormType StructType
 * @subpackage Structs
 */
class CN22FormType extends AbstractStructBase
{
    /**
     * The LabelSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelSize;
    /**
     * The PrintsPerPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintsPerPage;
    /**
     * The LabelPrintType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelPrintType;
    /**
     * The CN22Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22Type;
    /**
     * The CN22OtherDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22OtherDescription;
    /**
     * The FoldHereText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FoldHereText;
    /**
     * The CN22Content
     * Meta information extracted from the WSDL
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\CN22ContentType[]
     */
    public $CN22Content;
    /**
     * Constructor method for CN22FormType
     * @uses CN22FormType::setLabelSize()
     * @uses CN22FormType::setPrintsPerPage()
     * @uses CN22FormType::setLabelPrintType()
     * @uses CN22FormType::setCN22Type()
     * @uses CN22FormType::setCN22OtherDescription()
     * @uses CN22FormType::setFoldHereText()
     * @uses CN22FormType::setCN22Content()
     * @param string $labelSize
     * @param string $printsPerPage
     * @param string $labelPrintType
     * @param string $cN22Type
     * @param string $cN22OtherDescription
     * @param string $foldHereText
     * @param \StructType\CN22ContentType[] $cN22Content
     */
    public function __construct($labelSize = null, $printsPerPage = null, $labelPrintType = null, $cN22Type = null, $cN22OtherDescription = null, $foldHereText = null, array $cN22Content = array())
    {
        $this
            ->setLabelSize($labelSize)
            ->setPrintsPerPage($printsPerPage)
            ->setLabelPrintType($labelPrintType)
            ->setCN22Type($cN22Type)
            ->setCN22OtherDescription($cN22OtherDescription)
            ->setFoldHereText($foldHereText)
            ->setCN22Content($cN22Content);
    }
    /**
     * Get LabelSize value
     * @return string|null
     */
    public function getLabelSize()
    {
        return $this->LabelSize;
    }
    /**
     * Set LabelSize value
     * @param string $labelSize
     * @return \StructType\CN22FormType
     */
    public function setLabelSize($labelSize = null)
    {
        // validation for constraint: string
        if (!is_null($labelSize) && !is_string($labelSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelSize, true), gettype($labelSize)), __LINE__);
        }
        $this->LabelSize = $labelSize;
        return $this;
    }
    /**
     * Get PrintsPerPage value
     * @return string|null
     */
    public function getPrintsPerPage()
    {
        return $this->PrintsPerPage;
    }
    /**
     * Set PrintsPerPage value
     * @param string $printsPerPage
     * @return \StructType\CN22FormType
     */
    public function setPrintsPerPage($printsPerPage = null)
    {
        // validation for constraint: string
        if (!is_null($printsPerPage) && !is_string($printsPerPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printsPerPage, true), gettype($printsPerPage)), __LINE__);
        }
        $this->PrintsPerPage = $printsPerPage;
        return $this;
    }
    /**
     * Get LabelPrintType value
     * @return string|null
     */
    public function getLabelPrintType()
    {
        return $this->LabelPrintType;
    }
    /**
     * Set LabelPrintType value
     * @param string $labelPrintType
     * @return \StructType\CN22FormType
     */
    public function setLabelPrintType($labelPrintType = null)
    {
        // validation for constraint: string
        if (!is_null($labelPrintType) && !is_string($labelPrintType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelPrintType, true), gettype($labelPrintType)), __LINE__);
        }
        $this->LabelPrintType = $labelPrintType;
        return $this;
    }
    /**
     * Get CN22Type value
     * @return string|null
     */
    public function getCN22Type()
    {
        return $this->CN22Type;
    }
    /**
     * Set CN22Type value
     * @param string $cN22Type
     * @return \StructType\CN22FormType
     */
    public function setCN22Type($cN22Type = null)
    {
        // validation for constraint: string
        if (!is_null($cN22Type) && !is_string($cN22Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22Type, true), gettype($cN22Type)), __LINE__);
        }
        $this->CN22Type = $cN22Type;
        return $this;
    }
    /**
     * Get CN22OtherDescription value
     * @return string|null
     */
    public function getCN22OtherDescription()
    {
        return $this->CN22OtherDescription;
    }
    /**
     * Set CN22OtherDescription value
     * @param string $cN22OtherDescription
     * @return \StructType\CN22FormType
     */
    public function setCN22OtherDescription($cN22OtherDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cN22OtherDescription) && !is_string($cN22OtherDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22OtherDescription, true), gettype($cN22OtherDescription)), __LINE__);
        }
        $this->CN22OtherDescription = $cN22OtherDescription;
        return $this;
    }
    /**
     * Get FoldHereText value
     * @return string|null
     */
    public function getFoldHereText()
    {
        return $this->FoldHereText;
    }
    /**
     * Set FoldHereText value
     * @param string $foldHereText
     * @return \StructType\CN22FormType
     */
    public function setFoldHereText($foldHereText = null)
    {
        // validation for constraint: string
        if (!is_null($foldHereText) && !is_string($foldHereText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foldHereText, true), gettype($foldHereText)), __LINE__);
        }
        $this->FoldHereText = $foldHereText;
        return $this;
    }
    /**
     * Get CN22Content value
     * @return \StructType\CN22ContentType[]|null
     */
    public function getCN22Content()
    {
        return $this->CN22Content;
    }
    /**
     * This method is responsible for validating the values passed to the setCN22Content method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCN22Content method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCN22ContentForArrayConstraintsFromSetCN22Content(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cN22FormTypeCN22ContentItem) {
            // validation for constraint: itemType
            if (!$cN22FormTypeCN22ContentItem instanceof \StructType\CN22ContentType) {
                $invalidValues[] = is_object($cN22FormTypeCN22ContentItem) ? get_class($cN22FormTypeCN22ContentItem) : sprintf('%s(%s)', gettype($cN22FormTypeCN22ContentItem), var_export($cN22FormTypeCN22ContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CN22Content property can only contain items of type \StructType\CN22ContentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CN22Content value
     * @throws \InvalidArgumentException
     * @param \StructType\CN22ContentType[] $cN22Content
     * @return \StructType\CN22FormType
     */
    public function setCN22Content(array $cN22Content = array())
    {
        // validation for constraint: array
        if ('' !== ($cN22ContentArrayErrorMessage = self::validateCN22ContentForArrayConstraintsFromSetCN22Content($cN22Content))) {
            throw new \InvalidArgumentException($cN22ContentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($cN22Content) && count($cN22Content) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($cN22Content)), __LINE__);
        }
        $this->CN22Content = $cN22Content;
        return $this;
    }
    /**
     * Add item to CN22Content value
     * @throws \InvalidArgumentException
     * @param \StructType\CN22ContentType $item
     * @return \StructType\CN22FormType
     */
    public function addToCN22Content(\StructType\CN22ContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CN22ContentType) {
            throw new \InvalidArgumentException(sprintf('The CN22Content property can only contain items of type \StructType\CN22ContentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->CN22Content) && count($this->CN22Content) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->CN22Content)), __LINE__);
        }
        $this->CN22Content[] = $item;
        return $this;
    }
}
