<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitType StructType
 * @subpackage Structs
 */
class UnitType extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The UnitOfMeasurement
     * @var \StructType\UnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for UnitType
     * @uses UnitType::setNumber()
     * @uses UnitType::setUnitOfMeasurement()
     * @uses UnitType::setValue()
     * @param string $number
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @param string $value
     */
    public function __construct($number = null, \StructType\UnitOfMeasurementType $unitOfMeasurement = null, $value = null)
    {
        $this
            ->setNumber($number)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setValue($value);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\UnitType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\UnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\UnitType
     */
    public function setUnitOfMeasurement(\StructType\UnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\UnitType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
