<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UltimateConsigneeType StructType
 * @subpackage Structs
 */
class UltimateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The UltimateConsigneeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UltimateConsigneeTypeType
     */
    public $UltimateConsigneeType;
    /**
     * Constructor method for UltimateConsigneeType
     * @uses UltimateConsigneeType::setCompanyName()
     * @uses UltimateConsigneeType::setAddress()
     * @uses UltimateConsigneeType::setUltimateConsigneeType()
     * @param string $companyName
     * @param \StructType\AddressType $address
     * @param \StructType\UltimateConsigneeTypeType $ultimateConsigneeType
     */
    public function __construct($companyName = null, \StructType\AddressType $address = null, \StructType\UltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setUltimateConsigneeType($ultimateConsigneeType);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\UltimateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\UltimateConsigneeType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UltimateConsigneeType value
     * @return \StructType\UltimateConsigneeTypeType|null
     */
    public function getUltimateConsigneeType()
    {
        return $this->UltimateConsigneeType;
    }
    /**
     * Set UltimateConsigneeType value
     * @param \StructType\UltimateConsigneeTypeType $ultimateConsigneeType
     * @return \StructType\UltimateConsigneeType
     */
    public function setUltimateConsigneeType(\StructType\UltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this->UltimateConsigneeType = $ultimateConsigneeType;
        return $this;
    }
}
