<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationChargeType StructType
 * @subpackage Structs
 */
class TransportationChargeType extends AbstractStructBase
{
    /**
     * The GrossCharge
     * @var \StructType\ShipChargeType
     */
    public $GrossCharge;
    /**
     * The DiscountAmount
     * @var \StructType\ShipChargeType
     */
    public $DiscountAmount;
    /**
     * The DiscountPercentage
     * @var string
     */
    public $DiscountPercentage;
    /**
     * The NetCharge
     * @var \StructType\ShipChargeType
     */
    public $NetCharge;
    /**
     * Constructor method for TransportationChargeType
     * @uses TransportationChargeType::setGrossCharge()
     * @uses TransportationChargeType::setDiscountAmount()
     * @uses TransportationChargeType::setDiscountPercentage()
     * @uses TransportationChargeType::setNetCharge()
     * @param \StructType\ShipChargeType $grossCharge
     * @param \StructType\ShipChargeType $discountAmount
     * @param string $discountPercentage
     * @param \StructType\ShipChargeType $netCharge
     */
    public function __construct(\StructType\ShipChargeType $grossCharge = null, \StructType\ShipChargeType $discountAmount = null, $discountPercentage = null, \StructType\ShipChargeType $netCharge = null)
    {
        $this
            ->setGrossCharge($grossCharge)
            ->setDiscountAmount($discountAmount)
            ->setDiscountPercentage($discountPercentage)
            ->setNetCharge($netCharge);
    }
    /**
     * Get GrossCharge value
     * @return \StructType\ShipChargeType|null
     */
    public function getGrossCharge()
    {
        return $this->GrossCharge;
    }
    /**
     * Set GrossCharge value
     * @param \StructType\ShipChargeType $grossCharge
     * @return \StructType\TransportationChargeType
     */
    public function setGrossCharge(\StructType\ShipChargeType $grossCharge = null)
    {
        $this->GrossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \StructType\ShipChargeType|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \StructType\ShipChargeType $discountAmount
     * @return \StructType\TransportationChargeType
     */
    public function setDiscountAmount(\StructType\ShipChargeType $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return string|null
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param string $discountPercentage
     * @return \StructType\TransportationChargeType
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($discountPercentage) && !is_string($discountPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Get NetCharge value
     * @return \StructType\ShipChargeType|null
     */
    public function getNetCharge()
    {
        return $this->NetCharge;
    }
    /**
     * Set NetCharge value
     * @param \StructType\ShipChargeType $netCharge
     * @return \StructType\TransportationChargeType
     */
    public function setNetCharge(\StructType\ShipChargeType $netCharge = null)
    {
        $this->NetCharge = $netCharge;
        return $this;
    }
}
