<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentRequest StructType
 * @subpackage Structs
 */
class ShipmentRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \StructType\RequestType
     */
    public $Request;
    /**
     * The Shipment
     * @var \StructType\ShipmentType
     */
    public $Shipment;
    /**
     * The LabelSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LabelSpecificationType
     */
    public $LabelSpecification;
    /**
     * The ReceiptSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReceiptSpecificationType
     */
    public $ReceiptSpecification;
    /**
     * Constructor method for ShipmentRequest
     * @uses ShipmentRequest::setRequest()
     * @uses ShipmentRequest::setShipment()
     * @uses ShipmentRequest::setLabelSpecification()
     * @uses ShipmentRequest::setReceiptSpecification()
     * @param \StructType\RequestType $request
     * @param \StructType\ShipmentType $shipment
     * @param \StructType\LabelSpecificationType $labelSpecification
     * @param \StructType\ReceiptSpecificationType $receiptSpecification
     */
    public function __construct(\StructType\RequestType $request = null, \StructType\ShipmentType $shipment = null, \StructType\LabelSpecificationType $labelSpecification = null, \StructType\ReceiptSpecificationType $receiptSpecification = null)
    {
        $this
            ->setRequest($request)
            ->setShipment($shipment)
            ->setLabelSpecification($labelSpecification)
            ->setReceiptSpecification($receiptSpecification);
    }
    /**
     * Get Request value
     * @return \StructType\RequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\RequestType $request
     * @return \StructType\ShipmentRequest
     */
    public function setRequest(\StructType\RequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \StructType\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \StructType\ShipmentType $shipment
     * @return \StructType\ShipmentRequest
     */
    public function setShipment(\StructType\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get LabelSpecification value
     * @return \StructType\LabelSpecificationType|null
     */
    public function getLabelSpecification()
    {
        return $this->LabelSpecification;
    }
    /**
     * Set LabelSpecification value
     * @param \StructType\LabelSpecificationType $labelSpecification
     * @return \StructType\ShipmentRequest
     */
    public function setLabelSpecification(\StructType\LabelSpecificationType $labelSpecification = null)
    {
        $this->LabelSpecification = $labelSpecification;
        return $this;
    }
    /**
     * Get ReceiptSpecification value
     * @return \StructType\ReceiptSpecificationType|null
     */
    public function getReceiptSpecification()
    {
        return $this->ReceiptSpecification;
    }
    /**
     * Set ReceiptSpecification value
     * @param \StructType\ReceiptSpecificationType $receiptSpecification
     * @return \StructType\ShipmentRequest
     */
    public function setReceiptSpecification(\StructType\ReceiptSpecificationType $receiptSpecification = null)
    {
        $this->ReceiptSpecification = $receiptSpecification;
        return $this;
    }
}
