<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipFromType StructType
 * @subpackage Structs
 */
class ShipFromType extends CompanyInfoType
{
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The Address
     * @var \StructType\ShipAddressType
     */
    public $Address;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The VendorInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorInfoType
     */
    public $VendorInfo;
    /**
     * Constructor method for ShipFromType
     * @uses ShipFromType::setFaxNumber()
     * @uses ShipFromType::setAddress()
     * @uses ShipFromType::setEMailAddress()
     * @uses ShipFromType::setVendorInfo()
     * @param string $faxNumber
     * @param \StructType\ShipAddressType $address
     * @param string $eMailAddress
     * @param \StructType\VendorInfoType $vendorInfo
     */
    public function __construct($faxNumber = null, \StructType\ShipAddressType $address = null, $eMailAddress = null, \StructType\VendorInfoType $vendorInfo = null)
    {
        $this
            ->setFaxNumber($faxNumber)
            ->setAddress($address)
            ->setEMailAddress($eMailAddress)
            ->setVendorInfo($vendorInfo);
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \StructType\ShipFromType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\ShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\ShipAddressType $address
     * @return \StructType\ShipFromType
     */
    public function setAddress(\StructType\ShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \StructType\ShipFromType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get VendorInfo value
     * @return \StructType\VendorInfoType|null
     */
    public function getVendorInfo()
    {
        return $this->VendorInfo;
    }
    /**
     * Set VendorInfo value
     * @param \StructType\VendorInfoType $vendorInfo
     * @return \StructType\ShipFromType
     */
    public function setVendorInfo(\StructType\VendorInfoType $vendorInfo = null)
    {
        $this->VendorInfo = $vendorInfo;
        return $this;
    }
}
