<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipAcceptResponse StructType
 * @subpackage Structs
 */
class ShipAcceptResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \StructType\ResponseType
     */
    public $Response;
    /**
     * The ShipmentResults
     * @var \StructType\ShipmentResultsType
     */
    public $ShipmentResults;
    /**
     * Constructor method for ShipAcceptResponse
     * @uses ShipAcceptResponse::setResponse()
     * @uses ShipAcceptResponse::setShipmentResults()
     * @param \StructType\ResponseType $response
     * @param \StructType\ShipmentResultsType $shipmentResults
     */
    public function __construct(\StructType\ResponseType $response = null, \StructType\ShipmentResultsType $shipmentResults = null)
    {
        $this
            ->setResponse($response)
            ->setShipmentResults($shipmentResults);
    }
    /**
     * Get Response value
     * @return \StructType\ResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \StructType\ResponseType $response
     * @return \StructType\ShipAcceptResponse
     */
    public function setResponse(\StructType\ResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ShipmentResults value
     * @return \StructType\ShipmentResultsType|null
     */
    public function getShipmentResults()
    {
        return $this->ShipmentResults;
    }
    /**
     * Set ShipmentResults value
     * @param \StructType\ShipmentResultsType $shipmentResults
     * @return \StructType\ShipAcceptResponse
     */
    public function setShipmentResults(\StructType\ShipmentResultsType $shipmentResults = null)
    {
        $this->ShipmentResults = $shipmentResults;
        return $this;
    }
}
