<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageResultsType StructType
 * @subpackage Structs
 */
class PackageResultsType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The ServiceOptionsCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The ShippingLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LabelType
     */
    public $ShippingLabel;
    /**
     * The ShippingReceipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReceiptType
     */
    public $ShippingReceipt;
    /**
     * The USPSPICNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USPSPICNumber;
    /**
     * The CN22Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22Number;
    /**
     * The Accessorial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccessorialType[]
     */
    public $Accessorial;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormType
     */
    public $Form;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The NegotiatedCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NegotiatedChargesType
     */
    public $NegotiatedCharges;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SimpleRateType
     */
    public $SimpleRate;
    /**
     * The SensorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SensorID;
    /**
     * The CommodityDutyCharges
     * @var \StructType\CommodityDutyChargesType
     */
    public $CommodityDutyCharges;
    /**
     * Constructor method for PackageResultsType
     * @uses PackageResultsType::setTrackingNumber()
     * @uses PackageResultsType::setBaseServiceCharge()
     * @uses PackageResultsType::setServiceOptionsCharges()
     * @uses PackageResultsType::setShippingLabel()
     * @uses PackageResultsType::setShippingReceipt()
     * @uses PackageResultsType::setUSPSPICNumber()
     * @uses PackageResultsType::setCN22Number()
     * @uses PackageResultsType::setAccessorial()
     * @uses PackageResultsType::setForm()
     * @uses PackageResultsType::setItemizedCharges()
     * @uses PackageResultsType::setNegotiatedCharges()
     * @uses PackageResultsType::setSimpleRate()
     * @uses PackageResultsType::setSensorID()
     * @uses PackageResultsType::setCommodityDutyCharges()
     * @param string $trackingNumber
     * @param \StructType\ShipChargeType $baseServiceCharge
     * @param \StructType\ShipChargeType $serviceOptionsCharges
     * @param \StructType\LabelType $shippingLabel
     * @param \StructType\ReceiptType $shippingReceipt
     * @param string $uSPSPICNumber
     * @param string $cN22Number
     * @param \StructType\AccessorialType[] $accessorial
     * @param \StructType\FormType $form
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @param \StructType\NegotiatedChargesType $negotiatedCharges
     * @param \StructType\SimpleRateType $simpleRate
     * @param string $sensorID
     * @param \StructType\CommodityDutyChargesType $commodityDutyCharges
     */
    public function __construct($trackingNumber = null, \StructType\ShipChargeType $baseServiceCharge = null, \StructType\ShipChargeType $serviceOptionsCharges = null, \StructType\LabelType $shippingLabel = null, \StructType\ReceiptType $shippingReceipt = null, $uSPSPICNumber = null, $cN22Number = null, array $accessorial = array(), \StructType\FormType $form = null, array $itemizedCharges = array(), \StructType\NegotiatedChargesType $negotiatedCharges = null, \StructType\SimpleRateType $simpleRate = null, $sensorID = null, \StructType\CommodityDutyChargesType $commodityDutyCharges = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setShippingLabel($shippingLabel)
            ->setShippingReceipt($shippingReceipt)
            ->setUSPSPICNumber($uSPSPICNumber)
            ->setCN22Number($cN22Number)
            ->setAccessorial($accessorial)
            ->setForm($form)
            ->setItemizedCharges($itemizedCharges)
            ->setNegotiatedCharges($negotiatedCharges)
            ->setSimpleRate($simpleRate)
            ->setSensorID($sensorID)
            ->setCommodityDutyCharges($commodityDutyCharges);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\PackageResultsType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \StructType\ShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \StructType\ShipChargeType $baseServiceCharge
     * @return \StructType\PackageResultsType
     */
    public function setBaseServiceCharge(\StructType\ShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \StructType\ShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \StructType\ShipChargeType $serviceOptionsCharges
     * @return \StructType\PackageResultsType
     */
    public function setServiceOptionsCharges(\StructType\ShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get ShippingLabel value
     * @return \StructType\LabelType|null
     */
    public function getShippingLabel()
    {
        return $this->ShippingLabel;
    }
    /**
     * Set ShippingLabel value
     * @param \StructType\LabelType $shippingLabel
     * @return \StructType\PackageResultsType
     */
    public function setShippingLabel(\StructType\LabelType $shippingLabel = null)
    {
        $this->ShippingLabel = $shippingLabel;
        return $this;
    }
    /**
     * Get ShippingReceipt value
     * @return \StructType\ReceiptType|null
     */
    public function getShippingReceipt()
    {
        return $this->ShippingReceipt;
    }
    /**
     * Set ShippingReceipt value
     * @param \StructType\ReceiptType $shippingReceipt
     * @return \StructType\PackageResultsType
     */
    public function setShippingReceipt(\StructType\ReceiptType $shippingReceipt = null)
    {
        $this->ShippingReceipt = $shippingReceipt;
        return $this;
    }
    /**
     * Get USPSPICNumber value
     * @return string|null
     */
    public function getUSPSPICNumber()
    {
        return $this->USPSPICNumber;
    }
    /**
     * Set USPSPICNumber value
     * @param string $uSPSPICNumber
     * @return \StructType\PackageResultsType
     */
    public function setUSPSPICNumber($uSPSPICNumber = null)
    {
        // validation for constraint: string
        if (!is_null($uSPSPICNumber) && !is_string($uSPSPICNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSPSPICNumber, true), gettype($uSPSPICNumber)), __LINE__);
        }
        $this->USPSPICNumber = $uSPSPICNumber;
        return $this;
    }
    /**
     * Get CN22Number value
     * @return string|null
     */
    public function getCN22Number()
    {
        return $this->CN22Number;
    }
    /**
     * Set CN22Number value
     * @param string $cN22Number
     * @return \StructType\PackageResultsType
     */
    public function setCN22Number($cN22Number = null)
    {
        // validation for constraint: string
        if (!is_null($cN22Number) && !is_string($cN22Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22Number, true), gettype($cN22Number)), __LINE__);
        }
        $this->CN22Number = $cN22Number;
        return $this;
    }
    /**
     * Get Accessorial value
     * @return \StructType\AccessorialType[]|null
     */
    public function getAccessorial()
    {
        return $this->Accessorial;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessorial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessorial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessorialForArrayConstraintsFromSetAccessorial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeAccessorialItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeAccessorialItem instanceof \StructType\AccessorialType) {
                $invalidValues[] = is_object($packageResultsTypeAccessorialItem) ? get_class($packageResultsTypeAccessorialItem) : sprintf('%s(%s)', gettype($packageResultsTypeAccessorialItem), var_export($packageResultsTypeAccessorialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accessorial property can only contain items of type \StructType\AccessorialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accessorial value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialType[] $accessorial
     * @return \StructType\PackageResultsType
     */
    public function setAccessorial(array $accessorial = array())
    {
        // validation for constraint: array
        if ('' !== ($accessorialArrayErrorMessage = self::validateAccessorialForArrayConstraintsFromSetAccessorial($accessorial))) {
            throw new \InvalidArgumentException($accessorialArrayErrorMessage, __LINE__);
        }
        $this->Accessorial = $accessorial;
        return $this;
    }
    /**
     * Add item to Accessorial value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialType $item
     * @return \StructType\PackageResultsType
     */
    public function addToAccessorial(\StructType\AccessorialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessorialType) {
            throw new \InvalidArgumentException(sprintf('The Accessorial property can only contain items of type \StructType\AccessorialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accessorial[] = $item;
        return $this;
    }
    /**
     * Get Form value
     * @return \StructType\FormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \StructType\FormType $form
     * @return \StructType\PackageResultsType
     */
    public function setForm(\StructType\FormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \StructType\ShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeItemizedChargesItem instanceof \StructType\ShipChargeType) {
                $invalidValues[] = is_object($packageResultsTypeItemizedChargesItem) ? get_class($packageResultsTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($packageResultsTypeItemizedChargesItem), var_export($packageResultsTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @return \StructType\PackageResultsType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType $item
     * @return \StructType\PackageResultsType
     */
    public function addToItemizedCharges(\StructType\ShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get NegotiatedCharges value
     * @return \StructType\NegotiatedChargesType|null
     */
    public function getNegotiatedCharges()
    {
        return $this->NegotiatedCharges;
    }
    /**
     * Set NegotiatedCharges value
     * @param \StructType\NegotiatedChargesType $negotiatedCharges
     * @return \StructType\PackageResultsType
     */
    public function setNegotiatedCharges(\StructType\NegotiatedChargesType $negotiatedCharges = null)
    {
        $this->NegotiatedCharges = $negotiatedCharges;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \StructType\SimpleRateType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \StructType\SimpleRateType $simpleRate
     * @return \StructType\PackageResultsType
     */
    public function setSimpleRate(\StructType\SimpleRateType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get SensorID value
     * @return string|null
     */
    public function getSensorID()
    {
        return $this->SensorID;
    }
    /**
     * Set SensorID value
     * @param string $sensorID
     * @return \StructType\PackageResultsType
     */
    public function setSensorID($sensorID = null)
    {
        // validation for constraint: string
        if (!is_null($sensorID) && !is_string($sensorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorID, true), gettype($sensorID)), __LINE__);
        }
        $this->SensorID = $sensorID;
        return $this;
    }
    /**
     * Get CommodityDutyCharges value
     * @return \StructType\CommodityDutyChargesType|null
     */
    public function getCommodityDutyCharges()
    {
        return $this->CommodityDutyCharges;
    }
    /**
     * Set CommodityDutyCharges value
     * @param \StructType\CommodityDutyChargesType $commodityDutyCharges
     * @return \StructType\PackageResultsType
     */
    public function setCommodityDutyCharges(\StructType\CommodityDutyChargesType $commodityDutyCharges = null)
    {
        $this->CommodityDutyCharges = $commodityDutyCharges;
        return $this;
    }
}
