<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationType StructType
 * @subpackage Structs
 */
class NotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \StructType\EmailDetailsType
     */
    public $EMail;
    /**
     * The VoiceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentServiceOptionsNotificationVoiceMessageType
     */
    public $VoiceMessage;
    /**
     * The TextMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentServiceOptionsNotificationTextMessageType
     */
    public $TextMessage;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocaleType
     */
    public $Locale;
    /**
     * Constructor method for NotificationType
     * @uses NotificationType::setNotificationCode()
     * @uses NotificationType::setEMail()
     * @uses NotificationType::setVoiceMessage()
     * @uses NotificationType::setTextMessage()
     * @uses NotificationType::setLocale()
     * @param string $notificationCode
     * @param \StructType\EmailDetailsType $eMail
     * @param \StructType\ShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @param \StructType\ShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @param \StructType\LocaleType $locale
     */
    public function __construct($notificationCode = null, \StructType\EmailDetailsType $eMail = null, \StructType\ShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null, \StructType\ShipmentServiceOptionsNotificationTextMessageType $textMessage = null, \StructType\LocaleType $locale = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail)
            ->setVoiceMessage($voiceMessage)
            ->setTextMessage($textMessage)
            ->setLocale($locale);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \StructType\NotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \StructType\EmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \StructType\EmailDetailsType $eMail
     * @return \StructType\NotificationType
     */
    public function setEMail(\StructType\EmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get VoiceMessage value
     * @return \StructType\ShipmentServiceOptionsNotificationVoiceMessageType|null
     */
    public function getVoiceMessage()
    {
        return $this->VoiceMessage;
    }
    /**
     * Set VoiceMessage value
     * @param \StructType\ShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @return \StructType\NotificationType
     */
    public function setVoiceMessage(\StructType\ShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null)
    {
        $this->VoiceMessage = $voiceMessage;
        return $this;
    }
    /**
     * Get TextMessage value
     * @return \StructType\ShipmentServiceOptionsNotificationTextMessageType|null
     */
    public function getTextMessage()
    {
        return $this->TextMessage;
    }
    /**
     * Set TextMessage value
     * @param \StructType\ShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @return \StructType\NotificationType
     */
    public function setTextMessage(\StructType\ShipmentServiceOptionsNotificationTextMessageType $textMessage = null)
    {
        $this->TextMessage = $textMessage;
        return $this;
    }
    /**
     * Get Locale value
     * @return \StructType\LocaleType|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \StructType\LocaleType $locale
     * @return \StructType\NotificationType
     */
    public function setLocale(\StructType\LocaleType $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
}
