<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelSpecificationType StructType
 * @subpackage Structs
 */
class LabelSpecificationType extends AbstractStructBase
{
    /**
     * The LabelImageFormat
     * @var \StructType\LabelImageFormatType
     */
    public $LabelImageFormat;
    /**
     * The HTTPUserAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTTPUserAgent;
    /**
     * The LabelStockSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LabelStockSizeType
     */
    public $LabelStockSize;
    /**
     * The Instruction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InstructionCodeDescriptionType[]
     */
    public $Instruction;
    /**
     * The CharacterSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CharacterSet;
    /**
     * Constructor method for LabelSpecificationType
     * @uses LabelSpecificationType::setLabelImageFormat()
     * @uses LabelSpecificationType::setHTTPUserAgent()
     * @uses LabelSpecificationType::setLabelStockSize()
     * @uses LabelSpecificationType::setInstruction()
     * @uses LabelSpecificationType::setCharacterSet()
     * @param \StructType\LabelImageFormatType $labelImageFormat
     * @param string $hTTPUserAgent
     * @param \StructType\LabelStockSizeType $labelStockSize
     * @param \StructType\InstructionCodeDescriptionType[] $instruction
     * @param string $characterSet
     */
    public function __construct(\StructType\LabelImageFormatType $labelImageFormat = null, $hTTPUserAgent = null, \StructType\LabelStockSizeType $labelStockSize = null, array $instruction = array(), $characterSet = null)
    {
        $this
            ->setLabelImageFormat($labelImageFormat)
            ->setHTTPUserAgent($hTTPUserAgent)
            ->setLabelStockSize($labelStockSize)
            ->setInstruction($instruction)
            ->setCharacterSet($characterSet);
    }
    /**
     * Get LabelImageFormat value
     * @return \StructType\LabelImageFormatType|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param \StructType\LabelImageFormatType $labelImageFormat
     * @return \StructType\LabelSpecificationType
     */
    public function setLabelImageFormat(\StructType\LabelImageFormatType $labelImageFormat = null)
    {
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get HTTPUserAgent value
     * @return string|null
     */
    public function getHTTPUserAgent()
    {
        return $this->HTTPUserAgent;
    }
    /**
     * Set HTTPUserAgent value
     * @param string $hTTPUserAgent
     * @return \StructType\LabelSpecificationType
     */
    public function setHTTPUserAgent($hTTPUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($hTTPUserAgent) && !is_string($hTTPUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTTPUserAgent, true), gettype($hTTPUserAgent)), __LINE__);
        }
        $this->HTTPUserAgent = $hTTPUserAgent;
        return $this;
    }
    /**
     * Get LabelStockSize value
     * @return \StructType\LabelStockSizeType|null
     */
    public function getLabelStockSize()
    {
        return $this->LabelStockSize;
    }
    /**
     * Set LabelStockSize value
     * @param \StructType\LabelStockSizeType $labelStockSize
     * @return \StructType\LabelSpecificationType
     */
    public function setLabelStockSize(\StructType\LabelStockSizeType $labelStockSize = null)
    {
        $this->LabelStockSize = $labelStockSize;
        return $this;
    }
    /**
     * Get Instruction value
     * @return \StructType\InstructionCodeDescriptionType[]|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * This method is responsible for validating the values passed to the setInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionForArrayConstraintsFromSetInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $labelSpecificationTypeInstructionItem) {
            // validation for constraint: itemType
            if (!$labelSpecificationTypeInstructionItem instanceof \StructType\InstructionCodeDescriptionType) {
                $invalidValues[] = is_object($labelSpecificationTypeInstructionItem) ? get_class($labelSpecificationTypeInstructionItem) : sprintf('%s(%s)', gettype($labelSpecificationTypeInstructionItem), var_export($labelSpecificationTypeInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instruction property can only contain items of type \StructType\InstructionCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instruction value
     * @throws \InvalidArgumentException
     * @param \StructType\InstructionCodeDescriptionType[] $instruction
     * @return \StructType\LabelSpecificationType
     */
    public function setInstruction(array $instruction = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionArrayErrorMessage = self::validateInstructionForArrayConstraintsFromSetInstruction($instruction))) {
            throw new \InvalidArgumentException($instructionArrayErrorMessage, __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Add item to Instruction value
     * @throws \InvalidArgumentException
     * @param \StructType\InstructionCodeDescriptionType $item
     * @return \StructType\LabelSpecificationType
     */
    public function addToInstruction(\StructType\InstructionCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstructionCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Instruction property can only contain items of type \StructType\InstructionCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instruction[] = $item;
        return $this;
    }
    /**
     * Get CharacterSet value
     * @return string|null
     */
    public function getCharacterSet()
    {
        return $this->CharacterSet;
    }
    /**
     * Set CharacterSet value
     * @param string $characterSet
     * @return \StructType\LabelSpecificationType
     */
    public function setCharacterSet($characterSet = null)
    {
        // validation for constraint: string
        if (!is_null($characterSet) && !is_string($characterSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterSet, true), gettype($characterSet)), __LINE__);
        }
        $this->CharacterSet = $characterSet;
        return $this;
    }
}
