<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsType StructType
 * @subpackage Structs
 */
class HandlingUnitsType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \StructType\ShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \StructType\HandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * Constructor method for HandlingUnitsType
     * @uses HandlingUnitsType::setQuantity()
     * @uses HandlingUnitsType::setType()
     * @uses HandlingUnitsType::setDimensions()
     * @param string $quantity
     * @param \StructType\ShipUnitOfMeasurementType $type
     * @param \StructType\HandlingUnitsDimensionsType $dimensions
     */
    public function __construct($quantity = null, \StructType\ShipUnitOfMeasurementType $type = null, \StructType\HandlingUnitsDimensionsType $dimensions = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\HandlingUnitsType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\ShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\ShipUnitOfMeasurementType $type
     * @return \StructType\HandlingUnitsType
     */
    public function setType(\StructType\ShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \StructType\HandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \StructType\HandlingUnitsDimensionsType $dimensions
     * @return \StructType\HandlingUnitsType
     */
    public function setDimensions(\StructType\HandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
}
