<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsResponseType StructType
 * @subpackage Structs
 */
class HandlingUnitsResponseType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \StructType\ShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \StructType\HandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * The AdjustedHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdjustedHeightType
     */
    public $AdjustedHeight;
    /**
     * Constructor method for HandlingUnitsResponseType
     * @uses HandlingUnitsResponseType::setQuantity()
     * @uses HandlingUnitsResponseType::setType()
     * @uses HandlingUnitsResponseType::setDimensions()
     * @uses HandlingUnitsResponseType::setAdjustedHeight()
     * @param string $quantity
     * @param \StructType\ShipUnitOfMeasurementType $type
     * @param \StructType\HandlingUnitsDimensionsType $dimensions
     * @param \StructType\AdjustedHeightType $adjustedHeight
     */
    public function __construct($quantity = null, \StructType\ShipUnitOfMeasurementType $type = null, \StructType\HandlingUnitsDimensionsType $dimensions = null, \StructType\AdjustedHeightType $adjustedHeight = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions)
            ->setAdjustedHeight($adjustedHeight);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\HandlingUnitsResponseType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\ShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\ShipUnitOfMeasurementType $type
     * @return \StructType\HandlingUnitsResponseType
     */
    public function setType(\StructType\ShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \StructType\HandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \StructType\HandlingUnitsDimensionsType $dimensions
     * @return \StructType\HandlingUnitsResponseType
     */
    public function setDimensions(\StructType\HandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get AdjustedHeight value
     * @return \StructType\AdjustedHeightType|null
     */
    public function getAdjustedHeight()
    {
        return $this->AdjustedHeight;
    }
    /**
     * Set AdjustedHeight value
     * @param \StructType\AdjustedHeightType $adjustedHeight
     * @return \StructType\HandlingUnitsResponseType
     */
    public function setAdjustedHeight(\StructType\AdjustedHeightType $adjustedHeight = null)
    {
        $this->AdjustedHeight = $adjustedHeight;
        return $this;
    }
}
