<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsDimensionsType StructType
 * @subpackage Structs
 */
class HandlingUnitsDimensionsType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \StructType\ShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Length
     * @var string
     */
    public $Length;
    /**
     * The Width
     * @var string
     */
    public $Width;
    /**
     * The Height
     * @var string
     */
    public $Height;
    /**
     * Constructor method for HandlingUnitsDimensionsType
     * @uses HandlingUnitsDimensionsType::setUnitOfMeasurement()
     * @uses HandlingUnitsDimensionsType::setLength()
     * @uses HandlingUnitsDimensionsType::setWidth()
     * @uses HandlingUnitsDimensionsType::setHeight()
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     * @param string $length
     * @param string $width
     * @param string $height
     */
    public function __construct(\StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null, $length = null, $width = null, $height = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\ShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\HandlingUnitsDimensionsType
     */
    public function setUnitOfMeasurement(\StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Length value
     * @return string|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param string $length
     * @return \StructType\HandlingUnitsDimensionsType
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param string $width
     * @return \StructType\HandlingUnitsDimensionsType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return string|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param string $height
     * @return \StructType\HandlingUnitsDimensionsType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
}
