<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForwardAgentType StructType
 * @subpackage Structs
 */
class ForwardAgentType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The TaxIdentificationNumber
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The Address
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for ForwardAgentType
     * @uses ForwardAgentType::setCompanyName()
     * @uses ForwardAgentType::setTaxIdentificationNumber()
     * @uses ForwardAgentType::setAddress()
     * @param string $companyName
     * @param string $taxIdentificationNumber
     * @param \StructType\AddressType $address
     */
    public function __construct($companyName = null, $taxIdentificationNumber = null, \StructType\AddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\ForwardAgentType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \StructType\ForwardAgentType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\ForwardAgentType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
