<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormType StructType
 * @subpackage Structs
 */
class FormType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormImageType
     */
    public $Image;
    /**
     * The FormGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormGroupId;
    /**
     * The FormGroupIdName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormGroupIdName;
    /**
     * Constructor method for FormType
     * @uses FormType::setCode()
     * @uses FormType::setDescription()
     * @uses FormType::setImage()
     * @uses FormType::setFormGroupId()
     * @uses FormType::setFormGroupIdName()
     * @param string $code
     * @param string $description
     * @param \StructType\FormImageType $image
     * @param string $formGroupId
     * @param string $formGroupIdName
     */
    public function __construct($code = null, $description = null, \StructType\FormImageType $image = null, $formGroupId = null, $formGroupIdName = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setImage($image)
            ->setFormGroupId($formGroupId)
            ->setFormGroupIdName($formGroupIdName);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FormType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\FormType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\FormImageType|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\FormImageType $image
     * @return \StructType\FormType
     */
    public function setImage(\StructType\FormImageType $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get FormGroupId value
     * @return string|null
     */
    public function getFormGroupId()
    {
        return $this->FormGroupId;
    }
    /**
     * Set FormGroupId value
     * @param string $formGroupId
     * @return \StructType\FormType
     */
    public function setFormGroupId($formGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($formGroupId) && !is_string($formGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formGroupId, true), gettype($formGroupId)), __LINE__);
        }
        $this->FormGroupId = $formGroupId;
        return $this;
    }
    /**
     * Get FormGroupIdName value
     * @return string|null
     */
    public function getFormGroupIdName()
    {
        return $this->FormGroupIdName;
    }
    /**
     * Set FormGroupIdName value
     * @param string $formGroupIdName
     * @return \StructType\FormType
     */
    public function setFormGroupIdName($formGroupIdName = null)
    {
        // validation for constraint: string
        if (!is_null($formGroupIdName) && !is_string($formGroupIdName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formGroupIdName, true), gettype($formGroupIdName)), __LINE__);
        }
        $this->FormGroupIdName = $formGroupIdName;
        return $this;
    }
}
