<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSShipmentDataType StructType
 * @subpackage Structs
 */
class FRSShipmentDataType extends AbstractStructBase
{
    /**
     * The TransportationCharges
     * @var \StructType\TransportationChargeType
     */
    public $TransportationCharges;
    /**
     * The FreightDensityRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FreightDensityRateType
     */
    public $FreightDensityRate;
    /**
     * The HandlingUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HandlingUnitsResponseType[]
     */
    public $HandlingUnits;
    /**
     * Constructor method for FRSShipmentDataType
     * @uses FRSShipmentDataType::setTransportationCharges()
     * @uses FRSShipmentDataType::setFreightDensityRate()
     * @uses FRSShipmentDataType::setHandlingUnits()
     * @param \StructType\TransportationChargeType $transportationCharges
     * @param \StructType\FreightDensityRateType $freightDensityRate
     * @param \StructType\HandlingUnitsResponseType[] $handlingUnits
     */
    public function __construct(\StructType\TransportationChargeType $transportationCharges = null, \StructType\FreightDensityRateType $freightDensityRate = null, array $handlingUnits = array())
    {
        $this
            ->setTransportationCharges($transportationCharges)
            ->setFreightDensityRate($freightDensityRate)
            ->setHandlingUnits($handlingUnits);
    }
    /**
     * Get TransportationCharges value
     * @return \StructType\TransportationChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \StructType\TransportationChargeType $transportationCharges
     * @return \StructType\FRSShipmentDataType
     */
    public function setTransportationCharges(\StructType\TransportationChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get FreightDensityRate value
     * @return \StructType\FreightDensityRateType|null
     */
    public function getFreightDensityRate()
    {
        return $this->FreightDensityRate;
    }
    /**
     * Set FreightDensityRate value
     * @param \StructType\FreightDensityRateType $freightDensityRate
     * @return \StructType\FRSShipmentDataType
     */
    public function setFreightDensityRate(\StructType\FreightDensityRateType $freightDensityRate = null)
    {
        $this->FreightDensityRate = $freightDensityRate;
        return $this;
    }
    /**
     * Get HandlingUnits value
     * @return \StructType\HandlingUnitsResponseType[]|null
     */
    public function getHandlingUnits()
    {
        return $this->HandlingUnits;
    }
    /**
     * This method is responsible for validating the values passed to the setHandlingUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHandlingUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fRSShipmentDataTypeHandlingUnitsItem) {
            // validation for constraint: itemType
            if (!$fRSShipmentDataTypeHandlingUnitsItem instanceof \StructType\HandlingUnitsResponseType) {
                $invalidValues[] = is_object($fRSShipmentDataTypeHandlingUnitsItem) ? get_class($fRSShipmentDataTypeHandlingUnitsItem) : sprintf('%s(%s)', gettype($fRSShipmentDataTypeHandlingUnitsItem), var_export($fRSShipmentDataTypeHandlingUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HandlingUnits property can only contain items of type \StructType\HandlingUnitsResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \StructType\HandlingUnitsResponseType[] $handlingUnits
     * @return \StructType\FRSShipmentDataType
     */
    public function setHandlingUnits(array $handlingUnits = array())
    {
        // validation for constraint: array
        if ('' !== ($handlingUnitsArrayErrorMessage = self::validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits($handlingUnits))) {
            throw new \InvalidArgumentException($handlingUnitsArrayErrorMessage, __LINE__);
        }
        $this->HandlingUnits = $handlingUnits;
        return $this;
    }
    /**
     * Add item to HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \StructType\HandlingUnitsResponseType $item
     * @return \StructType\FRSShipmentDataType
     */
    public function addToHandlingUnits(\StructType\HandlingUnitsResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HandlingUnitsResponseType) {
            throw new \InvalidArgumentException(sprintf('The HandlingUnits property can only contain items of type \StructType\HandlingUnitsResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HandlingUnits[] = $item;
        return $this;
    }
}
