<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EEIInformationType StructType
 * @subpackage Structs
 */
class EEIInformationType extends AbstractStructBase
{
    /**
     * The ExportInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportInformation;
    /**
     * The License
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EEILicenseType
     */
    public $License;
    /**
     * The DDTCInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DDTCInformationType
     */
    public $DDTCInformation;
    /**
     * Constructor method for EEIInformationType
     * @uses EEIInformationType::setExportInformation()
     * @uses EEIInformationType::setLicense()
     * @uses EEIInformationType::setDDTCInformation()
     * @param string $exportInformation
     * @param \StructType\EEILicenseType $license
     * @param \StructType\DDTCInformationType $dDTCInformation
     */
    public function __construct($exportInformation = null, \StructType\EEILicenseType $license = null, \StructType\DDTCInformationType $dDTCInformation = null)
    {
        $this
            ->setExportInformation($exportInformation)
            ->setLicense($license)
            ->setDDTCInformation($dDTCInformation);
    }
    /**
     * Get ExportInformation value
     * @return string|null
     */
    public function getExportInformation()
    {
        return $this->ExportInformation;
    }
    /**
     * Set ExportInformation value
     * @param string $exportInformation
     * @return \StructType\EEIInformationType
     */
    public function setExportInformation($exportInformation = null)
    {
        // validation for constraint: string
        if (!is_null($exportInformation) && !is_string($exportInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportInformation, true), gettype($exportInformation)), __LINE__);
        }
        $this->ExportInformation = $exportInformation;
        return $this;
    }
    /**
     * Get License value
     * @return \StructType\EEILicenseType|null
     */
    public function getLicense()
    {
        return $this->License;
    }
    /**
     * Set License value
     * @param \StructType\EEILicenseType $license
     * @return \StructType\EEIInformationType
     */
    public function setLicense(\StructType\EEILicenseType $license = null)
    {
        $this->License = $license;
        return $this;
    }
    /**
     * Get DDTCInformation value
     * @return \StructType\DDTCInformationType|null
     */
    public function getDDTCInformation()
    {
        return $this->DDTCInformation;
    }
    /**
     * Set DDTCInformation value
     * @param \StructType\DDTCInformationType $dDTCInformation
     * @return \StructType\EEIInformationType
     */
    public function setDDTCInformation(\StructType\DDTCInformationType $dDTCInformation = null)
    {
        $this->DDTCInformation = $dDTCInformation;
        return $this;
    }
}
