<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceWeightType StructType
 * @subpackage Structs
 */
class DryIceWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \StructType\ShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for DryIceWeightType
     * @uses DryIceWeightType::setUnitOfMeasurement()
     * @uses DryIceWeightType::setWeight()
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\ShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\DryIceWeightType
     */
    public function setUnitOfMeasurement(\StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\DryIceWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
