<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceType StructType
 * @subpackage Structs
 */
class DryIceType extends AbstractStructBase
{
    /**
     * The RegulationSet
     * @var string
     */
    public $RegulationSet;
    /**
     * The DryIceWeight
     * @var \StructType\DryIceWeightType
     */
    public $DryIceWeight;
    /**
     * The MedicalUseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MedicalUseIndicator;
    /**
     * Constructor method for DryIceType
     * @uses DryIceType::setRegulationSet()
     * @uses DryIceType::setDryIceWeight()
     * @uses DryIceType::setMedicalUseIndicator()
     * @param string $regulationSet
     * @param \StructType\DryIceWeightType $dryIceWeight
     * @param string $medicalUseIndicator
     */
    public function __construct($regulationSet = null, \StructType\DryIceWeightType $dryIceWeight = null, $medicalUseIndicator = null)
    {
        $this
            ->setRegulationSet($regulationSet)
            ->setDryIceWeight($dryIceWeight)
            ->setMedicalUseIndicator($medicalUseIndicator);
    }
    /**
     * Get RegulationSet value
     * @return string|null
     */
    public function getRegulationSet()
    {
        return $this->RegulationSet;
    }
    /**
     * Set RegulationSet value
     * @param string $regulationSet
     * @return \StructType\DryIceType
     */
    public function setRegulationSet($regulationSet = null)
    {
        // validation for constraint: string
        if (!is_null($regulationSet) && !is_string($regulationSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulationSet, true), gettype($regulationSet)), __LINE__);
        }
        $this->RegulationSet = $regulationSet;
        return $this;
    }
    /**
     * Get DryIceWeight value
     * @return \StructType\DryIceWeightType|null
     */
    public function getDryIceWeight()
    {
        return $this->DryIceWeight;
    }
    /**
     * Set DryIceWeight value
     * @param \StructType\DryIceWeightType $dryIceWeight
     * @return \StructType\DryIceType
     */
    public function setDryIceWeight(\StructType\DryIceWeightType $dryIceWeight = null)
    {
        $this->DryIceWeight = $dryIceWeight;
        return $this;
    }
    /**
     * Get MedicalUseIndicator value
     * @return string|null
     */
    public function getMedicalUseIndicator()
    {
        return $this->MedicalUseIndicator;
    }
    /**
     * Set MedicalUseIndicator value
     * @param string $medicalUseIndicator
     * @return \StructType\DryIceType
     */
    public function setMedicalUseIndicator($medicalUseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($medicalUseIndicator) && !is_string($medicalUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalUseIndicator, true), gettype($medicalUseIndicator)), __LINE__);
        }
        $this->MedicalUseIndicator = $medicalUseIndicator;
        return $this;
    }
}
