<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryConfirmationType StructType
 * @subpackage Structs
 */
class DeliveryConfirmationType extends AbstractStructBase
{
    /**
     * The DCISType
     * @var string
     */
    public $DCISType;
    /**
     * The DCISNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DCISNumber;
    /**
     * Constructor method for DeliveryConfirmationType
     * @uses DeliveryConfirmationType::setDCISType()
     * @uses DeliveryConfirmationType::setDCISNumber()
     * @param string $dCISType
     * @param string $dCISNumber
     */
    public function __construct($dCISType = null, $dCISNumber = null)
    {
        $this
            ->setDCISType($dCISType)
            ->setDCISNumber($dCISNumber);
    }
    /**
     * Get DCISType value
     * @return string|null
     */
    public function getDCISType()
    {
        return $this->DCISType;
    }
    /**
     * Set DCISType value
     * @param string $dCISType
     * @return \StructType\DeliveryConfirmationType
     */
    public function setDCISType($dCISType = null)
    {
        // validation for constraint: string
        if (!is_null($dCISType) && !is_string($dCISType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCISType, true), gettype($dCISType)), __LINE__);
        }
        $this->DCISType = $dCISType;
        return $this;
    }
    /**
     * Get DCISNumber value
     * @return string|null
     */
    public function getDCISNumber()
    {
        return $this->DCISNumber;
    }
    /**
     * Set DCISNumber value
     * @param string $dCISNumber
     * @return \StructType\DeliveryConfirmationType
     */
    public function setDCISNumber($dCISNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dCISNumber) && !is_string($dCISNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCISNumber, true), gettype($dCISNumber)), __LINE__);
        }
        $this->DCISNumber = $dCISNumber;
        return $this;
    }
}
