<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DDTCInformationType StructType
 * @subpackage Structs
 */
class DDTCInformationType extends AbstractStructBase
{
    /**
     * The ITARExemptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ITARExemptionNumber;
    /**
     * The USMLCategoryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USMLCategoryCode;
    /**
     * The EligiblePartyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EligiblePartyIndicator;
    /**
     * The RegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationNumber;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * The UnitOfMeasurement
     * @var \StructType\UnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The SignificantMilitaryEquipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SignificantMilitaryEquipmentIndicator;
    /**
     * The ACMNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ACMNumber;
    /**
     * Constructor method for DDTCInformationType
     * @uses DDTCInformationType::setITARExemptionNumber()
     * @uses DDTCInformationType::setUSMLCategoryCode()
     * @uses DDTCInformationType::setEligiblePartyIndicator()
     * @uses DDTCInformationType::setRegistrationNumber()
     * @uses DDTCInformationType::setQuantity()
     * @uses DDTCInformationType::setUnitOfMeasurement()
     * @uses DDTCInformationType::setSignificantMilitaryEquipmentIndicator()
     * @uses DDTCInformationType::setACMNumber()
     * @param string $iTARExemptionNumber
     * @param string $uSMLCategoryCode
     * @param string $eligiblePartyIndicator
     * @param string $registrationNumber
     * @param string $quantity
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @param string $significantMilitaryEquipmentIndicator
     * @param string $aCMNumber
     */
    public function __construct($iTARExemptionNumber = null, $uSMLCategoryCode = null, $eligiblePartyIndicator = null, $registrationNumber = null, $quantity = null, \StructType\UnitOfMeasurementType $unitOfMeasurement = null, $significantMilitaryEquipmentIndicator = null, $aCMNumber = null)
    {
        $this
            ->setITARExemptionNumber($iTARExemptionNumber)
            ->setUSMLCategoryCode($uSMLCategoryCode)
            ->setEligiblePartyIndicator($eligiblePartyIndicator)
            ->setRegistrationNumber($registrationNumber)
            ->setQuantity($quantity)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setSignificantMilitaryEquipmentIndicator($significantMilitaryEquipmentIndicator)
            ->setACMNumber($aCMNumber);
    }
    /**
     * Get ITARExemptionNumber value
     * @return string|null
     */
    public function getITARExemptionNumber()
    {
        return $this->ITARExemptionNumber;
    }
    /**
     * Set ITARExemptionNumber value
     * @param string $iTARExemptionNumber
     * @return \StructType\DDTCInformationType
     */
    public function setITARExemptionNumber($iTARExemptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iTARExemptionNumber) && !is_string($iTARExemptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iTARExemptionNumber, true), gettype($iTARExemptionNumber)), __LINE__);
        }
        $this->ITARExemptionNumber = $iTARExemptionNumber;
        return $this;
    }
    /**
     * Get USMLCategoryCode value
     * @return string|null
     */
    public function getUSMLCategoryCode()
    {
        return $this->USMLCategoryCode;
    }
    /**
     * Set USMLCategoryCode value
     * @param string $uSMLCategoryCode
     * @return \StructType\DDTCInformationType
     */
    public function setUSMLCategoryCode($uSMLCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($uSMLCategoryCode) && !is_string($uSMLCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSMLCategoryCode, true), gettype($uSMLCategoryCode)), __LINE__);
        }
        $this->USMLCategoryCode = $uSMLCategoryCode;
        return $this;
    }
    /**
     * Get EligiblePartyIndicator value
     * @return string|null
     */
    public function getEligiblePartyIndicator()
    {
        return $this->EligiblePartyIndicator;
    }
    /**
     * Set EligiblePartyIndicator value
     * @param string $eligiblePartyIndicator
     * @return \StructType\DDTCInformationType
     */
    public function setEligiblePartyIndicator($eligiblePartyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($eligiblePartyIndicator) && !is_string($eligiblePartyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eligiblePartyIndicator, true), gettype($eligiblePartyIndicator)), __LINE__);
        }
        $this->EligiblePartyIndicator = $eligiblePartyIndicator;
        return $this;
    }
    /**
     * Get RegistrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param string $registrationNumber
     * @return \StructType\DDTCInformationType
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationNumber, true), gettype($registrationNumber)), __LINE__);
        }
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\DDTCInformationType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\UnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\DDTCInformationType
     */
    public function setUnitOfMeasurement(\StructType\UnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get SignificantMilitaryEquipmentIndicator value
     * @return string|null
     */
    public function getSignificantMilitaryEquipmentIndicator()
    {
        return $this->SignificantMilitaryEquipmentIndicator;
    }
    /**
     * Set SignificantMilitaryEquipmentIndicator value
     * @param string $significantMilitaryEquipmentIndicator
     * @return \StructType\DDTCInformationType
     */
    public function setSignificantMilitaryEquipmentIndicator($significantMilitaryEquipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($significantMilitaryEquipmentIndicator) && !is_string($significantMilitaryEquipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($significantMilitaryEquipmentIndicator, true), gettype($significantMilitaryEquipmentIndicator)), __LINE__);
        }
        $this->SignificantMilitaryEquipmentIndicator = $significantMilitaryEquipmentIndicator;
        return $this;
    }
    /**
     * Get ACMNumber value
     * @return string|null
     */
    public function getACMNumber()
    {
        return $this->ACMNumber;
    }
    /**
     * Set ACMNumber value
     * @param string $aCMNumber
     * @return \StructType\DDTCInformationType
     */
    public function setACMNumber($aCMNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aCMNumber) && !is_string($aCMNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCMNumber, true), gettype($aCMNumber)), __LINE__);
        }
        $this->ACMNumber = $aCMNumber;
        return $this;
    }
}
