<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardType StructType
 * @subpackage Structs
 */
class CreditCardType extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The SecurityCode
     * @var string
     */
    public $SecurityCode;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CreditCardAddressType
     */
    public $Address;
    /**
     * Constructor method for CreditCardType
     * @uses CreditCardType::setType()
     * @uses CreditCardType::setNumber()
     * @uses CreditCardType::setExpirationDate()
     * @uses CreditCardType::setSecurityCode()
     * @uses CreditCardType::setAddress()
     * @param string $type
     * @param string $number
     * @param string $expirationDate
     * @param string $securityCode
     * @param \StructType\CreditCardAddressType $address
     */
    public function __construct($type = null, $number = null, $expirationDate = null, $securityCode = null, \StructType\CreditCardAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setExpirationDate($expirationDate)
            ->setSecurityCode($securityCode)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CreditCardType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\CreditCardType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\CreditCardType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get SecurityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->SecurityCode;
    }
    /**
     * Set SecurityCode value
     * @param string $securityCode
     * @return \StructType\CreditCardType
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityCode, true), gettype($securityCode)), __LINE__);
        }
        $this->SecurityCode = $securityCode;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\CreditCardAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\CreditCardAddressType $address
     * @return \StructType\CreditCardType
     */
    public function setAddress(\StructType\CreditCardAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
