<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommodityType StructType
 * @subpackage Structs
 */
class CommodityType extends AbstractStructBase
{
    /**
     * The FreightClass
     * @var string
     */
    public $FreightClass;
    /**
     * The NMFC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NMFCType
     */
    public $NMFC;
    /**
     * Constructor method for CommodityType
     * @uses CommodityType::setFreightClass()
     * @uses CommodityType::setNMFC()
     * @param string $freightClass
     * @param \StructType\NMFCType $nMFC
     */
    public function __construct($freightClass = null, \StructType\NMFCType $nMFC = null)
    {
        $this
            ->setFreightClass($freightClass)
            ->setNMFC($nMFC);
    }
    /**
     * Get FreightClass value
     * @return string|null
     */
    public function getFreightClass()
    {
        return $this->FreightClass;
    }
    /**
     * Set FreightClass value
     * @param string $freightClass
     * @return \StructType\CommodityType
     */
    public function setFreightClass($freightClass = null)
    {
        // validation for constraint: string
        if (!is_null($freightClass) && !is_string($freightClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightClass, true), gettype($freightClass)), __LINE__);
        }
        $this->FreightClass = $freightClass;
        return $this;
    }
    /**
     * Get NMFC value
     * @return \StructType\NMFCType|null
     */
    public function getNMFC()
    {
        return $this->NMFC;
    }
    /**
     * Set NMFC value
     * @param \StructType\NMFCType $nMFC
     * @return \StructType\CommodityType
     */
    public function setNMFC(\StructType\NMFCType $nMFC = null)
    {
        $this->NMFC = $nMFC;
        return $this;
    }
}
