<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommodityDutyChargesType StructType
 * @subpackage Structs
 */
class CommodityDutyChargesType extends AbstractStructBase
{
    /**
     * The CommodityDuty
     * @var string
     */
    public $CommodityDuty;
    /**
     * The TotalCommodityTaxAndFee
     * @var string
     */
    public $TotalCommodityTaxAndFee;
    /**
     * The CommodityVAT
     * @var string
     */
    public $CommodityVAT;
    /**
     * Constructor method for CommodityDutyChargesType
     * @uses CommodityDutyChargesType::setCommodityDuty()
     * @uses CommodityDutyChargesType::setTotalCommodityTaxAndFee()
     * @uses CommodityDutyChargesType::setCommodityVAT()
     * @param string $commodityDuty
     * @param string $totalCommodityTaxAndFee
     * @param string $commodityVAT
     */
    public function __construct($commodityDuty = null, $totalCommodityTaxAndFee = null, $commodityVAT = null)
    {
        $this
            ->setCommodityDuty($commodityDuty)
            ->setTotalCommodityTaxAndFee($totalCommodityTaxAndFee)
            ->setCommodityVAT($commodityVAT);
    }
    /**
     * Get CommodityDuty value
     * @return string|null
     */
    public function getCommodityDuty()
    {
        return $this->CommodityDuty;
    }
    /**
     * Set CommodityDuty value
     * @param string $commodityDuty
     * @return \StructType\CommodityDutyChargesType
     */
    public function setCommodityDuty($commodityDuty = null)
    {
        // validation for constraint: string
        if (!is_null($commodityDuty) && !is_string($commodityDuty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityDuty, true), gettype($commodityDuty)), __LINE__);
        }
        $this->CommodityDuty = $commodityDuty;
        return $this;
    }
    /**
     * Get TotalCommodityTaxAndFee value
     * @return string|null
     */
    public function getTotalCommodityTaxAndFee()
    {
        return $this->TotalCommodityTaxAndFee;
    }
    /**
     * Set TotalCommodityTaxAndFee value
     * @param string $totalCommodityTaxAndFee
     * @return \StructType\CommodityDutyChargesType
     */
    public function setTotalCommodityTaxAndFee($totalCommodityTaxAndFee = null)
    {
        // validation for constraint: string
        if (!is_null($totalCommodityTaxAndFee) && !is_string($totalCommodityTaxAndFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalCommodityTaxAndFee, true), gettype($totalCommodityTaxAndFee)), __LINE__);
        }
        $this->TotalCommodityTaxAndFee = $totalCommodityTaxAndFee;
        return $this;
    }
    /**
     * Get CommodityVAT value
     * @return string|null
     */
    public function getCommodityVAT()
    {
        return $this->CommodityVAT;
    }
    /**
     * Set CommodityVAT value
     * @param string $commodityVAT
     * @return \StructType\CommodityDutyChargesType
     */
    public function setCommodityVAT($commodityVAT = null)
    {
        // validation for constraint: string
        if (!is_null($commodityVAT) && !is_string($commodityVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityVAT, true), gettype($commodityVAT)), __LINE__);
        }
        $this->CommodityVAT = $commodityVAT;
        return $this;
    }
}
