<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillThirdPartyChargeType StructType
 * @subpackage Structs
 */
class BillThirdPartyChargeType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * @var \StructType\AccountAddressType
     */
    public $Address;
    /**
     * Constructor method for BillThirdPartyChargeType
     * @uses BillThirdPartyChargeType::setAccountNumber()
     * @uses BillThirdPartyChargeType::setAddress()
     * @param string $accountNumber
     * @param \StructType\AccountAddressType $address
     */
    public function __construct($accountNumber = null, \StructType\AccountAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BillThirdPartyChargeType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AccountAddressType $address
     * @return \StructType\BillThirdPartyChargeType
     */
    public function setAddress(\StructType\AccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
