<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\StructType\UPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessShipment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \StructType\UPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentRequest $body
     * @return \StructType\ShipmentResponse|bool
     */
    public function ProcessShipment(\StructType\ShipmentRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipConfirm
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \StructType\UPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipConfirmRequest $body
     * @return \StructType\ShipConfirmResponse|bool
     */
    public function ProcessShipConfirm(\StructType\ShipConfirmRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipConfirm($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipAccept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \StructType\UPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipAcceptRequest $body
     * @return \StructType\ShipAcceptResponse|bool
     */
    public function ProcessShipAccept(\StructType\ShipAcceptRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipAccept($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShipAcceptResponse|\StructType\ShipConfirmResponse|\StructType\ShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
