<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorInfoType StructType
 * @subpackage Structs
 */
class VendorInfoType extends AbstractStructBase
{
    /**
     * The VendorCollectIDTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCollectIDTypeCode;
    /**
     * The VendorCollectIDNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCollectIDNumber;
    /**
     * The ConsigneeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeType;
    /**
     * Constructor method for VendorInfoType
     * @uses VendorInfoType::setVendorCollectIDTypeCode()
     * @uses VendorInfoType::setVendorCollectIDNumber()
     * @uses VendorInfoType::setConsigneeType()
     * @param string $vendorCollectIDTypeCode
     * @param string $vendorCollectIDNumber
     * @param string $consigneeType
     */
    public function __construct($vendorCollectIDTypeCode = null, $vendorCollectIDNumber = null, $consigneeType = null)
    {
        $this
            ->setVendorCollectIDTypeCode($vendorCollectIDTypeCode)
            ->setVendorCollectIDNumber($vendorCollectIDNumber)
            ->setConsigneeType($consigneeType);
    }
    /**
     * Get VendorCollectIDTypeCode value
     * @return string|null
     */
    public function getVendorCollectIDTypeCode()
    {
        return $this->VendorCollectIDTypeCode;
    }
    /**
     * Set VendorCollectIDTypeCode value
     * @param string $vendorCollectIDTypeCode
     * @return \StructType\VendorInfoType
     */
    public function setVendorCollectIDTypeCode($vendorCollectIDTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCollectIDTypeCode) && !is_string($vendorCollectIDTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCollectIDTypeCode, true), gettype($vendorCollectIDTypeCode)), __LINE__);
        }
        $this->VendorCollectIDTypeCode = $vendorCollectIDTypeCode;
        return $this;
    }
    /**
     * Get VendorCollectIDNumber value
     * @return string|null
     */
    public function getVendorCollectIDNumber()
    {
        return $this->VendorCollectIDNumber;
    }
    /**
     * Set VendorCollectIDNumber value
     * @param string $vendorCollectIDNumber
     * @return \StructType\VendorInfoType
     */
    public function setVendorCollectIDNumber($vendorCollectIDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCollectIDNumber) && !is_string($vendorCollectIDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCollectIDNumber, true), gettype($vendorCollectIDNumber)), __LINE__);
        }
        $this->VendorCollectIDNumber = $vendorCollectIDNumber;
        return $this;
    }
    /**
     * Get ConsigneeType value
     * @return string|null
     */
    public function getConsigneeType()
    {
        return $this->ConsigneeType;
    }
    /**
     * Set ConsigneeType value
     * @param string $consigneeType
     * @return \StructType\VendorInfoType
     */
    public function setConsigneeType($consigneeType = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeType) && !is_string($consigneeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeType, true), gettype($consigneeType)), __LINE__);
        }
        $this->ConsigneeType = $consigneeType;
        return $this;
    }
}
