<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ReturnService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnServiceType
     */
    public $ReturnService;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The Shipper
     * @var \StructType\ShipperType
     */
    public $Shipper;
    /**
     * The ShipTo
     * @var \StructType\ShipToType
     */
    public $ShipTo;
    /**
     * The AlternateDeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlternateDeliveryAddressType
     */
    public $AlternateDeliveryAddress;
    /**
     * The ShipFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipFromType
     */
    public $ShipFrom;
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentInfoType
     */
    public $PaymentInformation;
    /**
     * The FRSPaymentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FRSPaymentInfoType
     */
    public $FRSPaymentInformation;
    /**
     * The FreightShipmentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FreightShipmentInformationType
     */
    public $FreightShipmentInformation;
    /**
     * The GoodsNotInFreeCirculationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GoodsNotInFreeCirculationIndicator;
    /**
     * The ShipmentRatingOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateInfoType
     */
    public $ShipmentRatingOptions;
    /**
     * The MovementReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MovementReferenceNumber;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\ReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The Service
     * @var \StructType\ServiceType
     */
    public $Service;
    /**
     * The InvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CurrencyMonetaryType
     */
    public $InvoiceLineTotal;
    /**
     * The NumOfPiecesInShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPiecesInShipment;
    /**
     * The USPSEndorsement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USPSEndorsement;
    /**
     * The MILabelCN22Indicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MILabelCN22Indicator;
    /**
     * The SubClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubClassification;
    /**
     * The CostCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CostCenter;
    /**
     * The CostCenterBarcodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CostCenterBarcodeIndicator;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageID;
    /**
     * The PackageIDBarcodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIDBarcodeIndicator;
    /**
     * The IrregularIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IrregularIndicator;
    /**
     * The ShipmentIndicationType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IndicationType[]
     */
    public $ShipmentIndicationType;
    /**
     * The MIDualReturnShipmentKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MIDualReturnShipmentKey;
    /**
     * The MIDualReturnShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MIDualReturnShipmentIndicator;
    /**
     * The RatingMethodRequestedIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RatingMethodRequestedIndicator;
    /**
     * The TaxInformationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxInformationIndicator;
    /**
     * The PromotionalDiscountInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionalDiscountInformationType
     */
    public $PromotionalDiscountInformation;
    /**
     * The DGSignatoryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DGSignatoryInfoType
     */
    public $DGSignatoryInfo;
    /**
     * The MasterCartonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonID;
    /**
     * The MasterCartonIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonIndicator;
    /**
     * The DeniedPartyScreeningIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeniedPartyScreeningIndicator;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * The ShipmentValueThresholdCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentValueThresholdCode;
    /**
     * The ShipmentServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentServiceOptions
     */
    public $ShipmentServiceOptions;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PackageType[]
     */
    public $Package;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setDescription()
     * @uses ShipmentType::setReturnService()
     * @uses ShipmentType::setDocumentsOnlyIndicator()
     * @uses ShipmentType::setShipper()
     * @uses ShipmentType::setShipTo()
     * @uses ShipmentType::setAlternateDeliveryAddress()
     * @uses ShipmentType::setShipFrom()
     * @uses ShipmentType::setPaymentInformation()
     * @uses ShipmentType::setFRSPaymentInformation()
     * @uses ShipmentType::setFreightShipmentInformation()
     * @uses ShipmentType::setGoodsNotInFreeCirculationIndicator()
     * @uses ShipmentType::setShipmentRatingOptions()
     * @uses ShipmentType::setMovementReferenceNumber()
     * @uses ShipmentType::setReferenceNumber()
     * @uses ShipmentType::setService()
     * @uses ShipmentType::setInvoiceLineTotal()
     * @uses ShipmentType::setNumOfPiecesInShipment()
     * @uses ShipmentType::setUSPSEndorsement()
     * @uses ShipmentType::setMILabelCN22Indicator()
     * @uses ShipmentType::setSubClassification()
     * @uses ShipmentType::setCostCenter()
     * @uses ShipmentType::setCostCenterBarcodeIndicator()
     * @uses ShipmentType::setPackageID()
     * @uses ShipmentType::setPackageIDBarcodeIndicator()
     * @uses ShipmentType::setIrregularIndicator()
     * @uses ShipmentType::setShipmentIndicationType()
     * @uses ShipmentType::setMIDualReturnShipmentKey()
     * @uses ShipmentType::setMIDualReturnShipmentIndicator()
     * @uses ShipmentType::setRatingMethodRequestedIndicator()
     * @uses ShipmentType::setTaxInformationIndicator()
     * @uses ShipmentType::setPromotionalDiscountInformation()
     * @uses ShipmentType::setDGSignatoryInfo()
     * @uses ShipmentType::setMasterCartonID()
     * @uses ShipmentType::setMasterCartonIndicator()
     * @uses ShipmentType::setDeniedPartyScreeningIndicator()
     * @uses ShipmentType::setLocale()
     * @uses ShipmentType::setShipmentValueThresholdCode()
     * @uses ShipmentType::setShipmentServiceOptions()
     * @uses ShipmentType::setPackage()
     * @param string $description
     * @param \StructType\ReturnServiceType $returnService
     * @param string $documentsOnlyIndicator
     * @param \StructType\ShipperType $shipper
     * @param \StructType\ShipToType $shipTo
     * @param \StructType\AlternateDeliveryAddressType $alternateDeliveryAddress
     * @param \StructType\ShipFromType $shipFrom
     * @param \StructType\PaymentInfoType $paymentInformation
     * @param \StructType\FRSPaymentInfoType $fRSPaymentInformation
     * @param \StructType\FreightShipmentInformationType $freightShipmentInformation
     * @param string $goodsNotInFreeCirculationIndicator
     * @param \StructType\RateInfoType $shipmentRatingOptions
     * @param string $movementReferenceNumber
     * @param \StructType\ReferenceNumberType[] $referenceNumber
     * @param \StructType\ServiceType $service
     * @param \StructType\CurrencyMonetaryType $invoiceLineTotal
     * @param string $numOfPiecesInShipment
     * @param string $uSPSEndorsement
     * @param string $mILabelCN22Indicator
     * @param string $subClassification
     * @param string $costCenter
     * @param string $costCenterBarcodeIndicator
     * @param string $packageID
     * @param string $packageIDBarcodeIndicator
     * @param string $irregularIndicator
     * @param \StructType\IndicationType[] $shipmentIndicationType
     * @param string $mIDualReturnShipmentKey
     * @param string $mIDualReturnShipmentIndicator
     * @param string $ratingMethodRequestedIndicator
     * @param string $taxInformationIndicator
     * @param \StructType\PromotionalDiscountInformationType $promotionalDiscountInformation
     * @param \StructType\DGSignatoryInfoType $dGSignatoryInfo
     * @param string $masterCartonID
     * @param string $masterCartonIndicator
     * @param string $deniedPartyScreeningIndicator
     * @param string $locale
     * @param string $shipmentValueThresholdCode
     * @param \StructType\ShipmentServiceOptions $shipmentServiceOptions
     * @param \StructType\PackageType[] $package
     */
    public function __construct($description = null, \StructType\ReturnServiceType $returnService = null, $documentsOnlyIndicator = null, \StructType\ShipperType $shipper = null, \StructType\ShipToType $shipTo = null, \StructType\AlternateDeliveryAddressType $alternateDeliveryAddress = null, \StructType\ShipFromType $shipFrom = null, \StructType\PaymentInfoType $paymentInformation = null, \StructType\FRSPaymentInfoType $fRSPaymentInformation = null, \StructType\FreightShipmentInformationType $freightShipmentInformation = null, $goodsNotInFreeCirculationIndicator = null, \StructType\RateInfoType $shipmentRatingOptions = null, $movementReferenceNumber = null, array $referenceNumber = array(), \StructType\ServiceType $service = null, \StructType\CurrencyMonetaryType $invoiceLineTotal = null, $numOfPiecesInShipment = null, $uSPSEndorsement = null, $mILabelCN22Indicator = null, $subClassification = null, $costCenter = null, $costCenterBarcodeIndicator = null, $packageID = null, $packageIDBarcodeIndicator = null, $irregularIndicator = null, array $shipmentIndicationType = array(), $mIDualReturnShipmentKey = null, $mIDualReturnShipmentIndicator = null, $ratingMethodRequestedIndicator = null, $taxInformationIndicator = null, \StructType\PromotionalDiscountInformationType $promotionalDiscountInformation = null, \StructType\DGSignatoryInfoType $dGSignatoryInfo = null, $masterCartonID = null, $masterCartonIndicator = null, $deniedPartyScreeningIndicator = null, $locale = null, $shipmentValueThresholdCode = null, \StructType\ShipmentServiceOptions $shipmentServiceOptions = null, array $package = array())
    {
        $this
            ->setDescription($description)
            ->setReturnService($returnService)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setShipper($shipper)
            ->setShipTo($shipTo)
            ->setAlternateDeliveryAddress($alternateDeliveryAddress)
            ->setShipFrom($shipFrom)
            ->setPaymentInformation($paymentInformation)
            ->setFRSPaymentInformation($fRSPaymentInformation)
            ->setFreightShipmentInformation($freightShipmentInformation)
            ->setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator)
            ->setShipmentRatingOptions($shipmentRatingOptions)
            ->setMovementReferenceNumber($movementReferenceNumber)
            ->setReferenceNumber($referenceNumber)
            ->setService($service)
            ->setInvoiceLineTotal($invoiceLineTotal)
            ->setNumOfPiecesInShipment($numOfPiecesInShipment)
            ->setUSPSEndorsement($uSPSEndorsement)
            ->setMILabelCN22Indicator($mILabelCN22Indicator)
            ->setSubClassification($subClassification)
            ->setCostCenter($costCenter)
            ->setCostCenterBarcodeIndicator($costCenterBarcodeIndicator)
            ->setPackageID($packageID)
            ->setPackageIDBarcodeIndicator($packageIDBarcodeIndicator)
            ->setIrregularIndicator($irregularIndicator)
            ->setShipmentIndicationType($shipmentIndicationType)
            ->setMIDualReturnShipmentKey($mIDualReturnShipmentKey)
            ->setMIDualReturnShipmentIndicator($mIDualReturnShipmentIndicator)
            ->setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator)
            ->setTaxInformationIndicator($taxInformationIndicator)
            ->setPromotionalDiscountInformation($promotionalDiscountInformation)
            ->setDGSignatoryInfo($dGSignatoryInfo)
            ->setMasterCartonID($masterCartonID)
            ->setMasterCartonIndicator($masterCartonIndicator)
            ->setDeniedPartyScreeningIndicator($deniedPartyScreeningIndicator)
            ->setLocale($locale)
            ->setShipmentValueThresholdCode($shipmentValueThresholdCode)
            ->setShipmentServiceOptions($shipmentServiceOptions)
            ->setPackage($package);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShipmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ReturnService value
     * @return \StructType\ReturnServiceType|null
     */
    public function getReturnService()
    {
        return $this->ReturnService;
    }
    /**
     * Set ReturnService value
     * @param \StructType\ReturnServiceType $returnService
     * @return \StructType\ShipmentType
     */
    public function setReturnService(\StructType\ReturnServiceType $returnService = null)
    {
        $this->ReturnService = $returnService;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \StructType\ShipmentType
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperType|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperType $shipper
     * @return \StructType\ShipmentType
     */
    public function setShipper(\StructType\ShipperType $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \StructType\ShipToType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \StructType\ShipToType $shipTo
     * @return \StructType\ShipmentType
     */
    public function setShipTo(\StructType\ShipToType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get AlternateDeliveryAddress value
     * @return \StructType\AlternateDeliveryAddressType|null
     */
    public function getAlternateDeliveryAddress()
    {
        return $this->AlternateDeliveryAddress;
    }
    /**
     * Set AlternateDeliveryAddress value
     * @param \StructType\AlternateDeliveryAddressType $alternateDeliveryAddress
     * @return \StructType\ShipmentType
     */
    public function setAlternateDeliveryAddress(\StructType\AlternateDeliveryAddressType $alternateDeliveryAddress = null)
    {
        $this->AlternateDeliveryAddress = $alternateDeliveryAddress;
        return $this;
    }
    /**
     * Get ShipFrom value
     * @return \StructType\ShipFromType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \StructType\ShipFromType $shipFrom
     * @return \StructType\ShipmentType
     */
    public function setShipFrom(\StructType\ShipFromType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \StructType\PaymentInfoType|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \StructType\PaymentInfoType $paymentInformation
     * @return \StructType\ShipmentType
     */
    public function setPaymentInformation(\StructType\PaymentInfoType $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get FRSPaymentInformation value
     * @return \StructType\FRSPaymentInfoType|null
     */
    public function getFRSPaymentInformation()
    {
        return $this->FRSPaymentInformation;
    }
    /**
     * Set FRSPaymentInformation value
     * @param \StructType\FRSPaymentInfoType $fRSPaymentInformation
     * @return \StructType\ShipmentType
     */
    public function setFRSPaymentInformation(\StructType\FRSPaymentInfoType $fRSPaymentInformation = null)
    {
        $this->FRSPaymentInformation = $fRSPaymentInformation;
        return $this;
    }
    /**
     * Get FreightShipmentInformation value
     * @return \StructType\FreightShipmentInformationType|null
     */
    public function getFreightShipmentInformation()
    {
        return $this->FreightShipmentInformation;
    }
    /**
     * Set FreightShipmentInformation value
     * @param \StructType\FreightShipmentInformationType $freightShipmentInformation
     * @return \StructType\ShipmentType
     */
    public function setFreightShipmentInformation(\StructType\FreightShipmentInformationType $freightShipmentInformation = null)
    {
        $this->FreightShipmentInformation = $freightShipmentInformation;
        return $this;
    }
    /**
     * Get GoodsNotInFreeCirculationIndicator value
     * @return string|null
     */
    public function getGoodsNotInFreeCirculationIndicator()
    {
        return $this->GoodsNotInFreeCirculationIndicator;
    }
    /**
     * Set GoodsNotInFreeCirculationIndicator value
     * @param string $goodsNotInFreeCirculationIndicator
     * @return \StructType\ShipmentType
     */
    public function setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($goodsNotInFreeCirculationIndicator) && !is_string($goodsNotInFreeCirculationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsNotInFreeCirculationIndicator, true), gettype($goodsNotInFreeCirculationIndicator)), __LINE__);
        }
        $this->GoodsNotInFreeCirculationIndicator = $goodsNotInFreeCirculationIndicator;
        return $this;
    }
    /**
     * Get ShipmentRatingOptions value
     * @return \StructType\RateInfoType|null
     */
    public function getShipmentRatingOptions()
    {
        return $this->ShipmentRatingOptions;
    }
    /**
     * Set ShipmentRatingOptions value
     * @param \StructType\RateInfoType $shipmentRatingOptions
     * @return \StructType\ShipmentType
     */
    public function setShipmentRatingOptions(\StructType\RateInfoType $shipmentRatingOptions = null)
    {
        $this->ShipmentRatingOptions = $shipmentRatingOptions;
        return $this;
    }
    /**
     * Get MovementReferenceNumber value
     * @return string|null
     */
    public function getMovementReferenceNumber()
    {
        return $this->MovementReferenceNumber;
    }
    /**
     * Set MovementReferenceNumber value
     * @param string $movementReferenceNumber
     * @return \StructType\ShipmentType
     */
    public function setMovementReferenceNumber($movementReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($movementReferenceNumber) && !is_string($movementReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReferenceNumber, true), gettype($movementReferenceNumber)), __LINE__);
        }
        $this->MovementReferenceNumber = $movementReferenceNumber;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \StructType\ReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeReferenceNumberItem instanceof \StructType\ReferenceNumberType) {
                $invalidValues[] = is_object($shipmentTypeReferenceNumberItem) ? get_class($shipmentTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($shipmentTypeReferenceNumberItem), var_export($shipmentTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \StructType\ReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNumberType[] $referenceNumber
     * @return \StructType\ShipmentType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($referenceNumber) && count($referenceNumber) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNumberType $item
     * @return \StructType\ShipmentType
     */
    public function addToReferenceNumber(\StructType\ReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \StructType\ReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\ServiceType $service
     * @return \StructType\ShipmentType
     */
    public function setService(\StructType\ServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get InvoiceLineTotal value
     * @return \StructType\CurrencyMonetaryType|null
     */
    public function getInvoiceLineTotal()
    {
        return $this->InvoiceLineTotal;
    }
    /**
     * Set InvoiceLineTotal value
     * @param \StructType\CurrencyMonetaryType $invoiceLineTotal
     * @return \StructType\ShipmentType
     */
    public function setInvoiceLineTotal(\StructType\CurrencyMonetaryType $invoiceLineTotal = null)
    {
        $this->InvoiceLineTotal = $invoiceLineTotal;
        return $this;
    }
    /**
     * Get NumOfPiecesInShipment value
     * @return string|null
     */
    public function getNumOfPiecesInShipment()
    {
        return $this->NumOfPiecesInShipment;
    }
    /**
     * Set NumOfPiecesInShipment value
     * @param string $numOfPiecesInShipment
     * @return \StructType\ShipmentType
     */
    public function setNumOfPiecesInShipment($numOfPiecesInShipment = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPiecesInShipment) && !is_string($numOfPiecesInShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPiecesInShipment, true), gettype($numOfPiecesInShipment)), __LINE__);
        }
        $this->NumOfPiecesInShipment = $numOfPiecesInShipment;
        return $this;
    }
    /**
     * Get USPSEndorsement value
     * @return string|null
     */
    public function getUSPSEndorsement()
    {
        return $this->USPSEndorsement;
    }
    /**
     * Set USPSEndorsement value
     * @param string $uSPSEndorsement
     * @return \StructType\ShipmentType
     */
    public function setUSPSEndorsement($uSPSEndorsement = null)
    {
        // validation for constraint: string
        if (!is_null($uSPSEndorsement) && !is_string($uSPSEndorsement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSPSEndorsement, true), gettype($uSPSEndorsement)), __LINE__);
        }
        $this->USPSEndorsement = $uSPSEndorsement;
        return $this;
    }
    /**
     * Get MILabelCN22Indicator value
     * @return string|null
     */
    public function getMILabelCN22Indicator()
    {
        return $this->MILabelCN22Indicator;
    }
    /**
     * Set MILabelCN22Indicator value
     * @param string $mILabelCN22Indicator
     * @return \StructType\ShipmentType
     */
    public function setMILabelCN22Indicator($mILabelCN22Indicator = null)
    {
        // validation for constraint: string
        if (!is_null($mILabelCN22Indicator) && !is_string($mILabelCN22Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mILabelCN22Indicator, true), gettype($mILabelCN22Indicator)), __LINE__);
        }
        $this->MILabelCN22Indicator = $mILabelCN22Indicator;
        return $this;
    }
    /**
     * Get SubClassification value
     * @return string|null
     */
    public function getSubClassification()
    {
        return $this->SubClassification;
    }
    /**
     * Set SubClassification value
     * @param string $subClassification
     * @return \StructType\ShipmentType
     */
    public function setSubClassification($subClassification = null)
    {
        // validation for constraint: string
        if (!is_null($subClassification) && !is_string($subClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subClassification, true), gettype($subClassification)), __LINE__);
        }
        $this->SubClassification = $subClassification;
        return $this;
    }
    /**
     * Get CostCenter value
     * @return string|null
     */
    public function getCostCenter()
    {
        return $this->CostCenter;
    }
    /**
     * Set CostCenter value
     * @param string $costCenter
     * @return \StructType\ShipmentType
     */
    public function setCostCenter($costCenter = null)
    {
        // validation for constraint: string
        if (!is_null($costCenter) && !is_string($costCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenter, true), gettype($costCenter)), __LINE__);
        }
        $this->CostCenter = $costCenter;
        return $this;
    }
    /**
     * Get CostCenterBarcodeIndicator value
     * @return string|null
     */
    public function getCostCenterBarcodeIndicator()
    {
        return $this->CostCenterBarcodeIndicator;
    }
    /**
     * Set CostCenterBarcodeIndicator value
     * @param string $costCenterBarcodeIndicator
     * @return \StructType\ShipmentType
     */
    public function setCostCenterBarcodeIndicator($costCenterBarcodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterBarcodeIndicator) && !is_string($costCenterBarcodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterBarcodeIndicator, true), gettype($costCenterBarcodeIndicator)), __LINE__);
        }
        $this->CostCenterBarcodeIndicator = $costCenterBarcodeIndicator;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \StructType\ShipmentType
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get PackageIDBarcodeIndicator value
     * @return string|null
     */
    public function getPackageIDBarcodeIndicator()
    {
        return $this->PackageIDBarcodeIndicator;
    }
    /**
     * Set PackageIDBarcodeIndicator value
     * @param string $packageIDBarcodeIndicator
     * @return \StructType\ShipmentType
     */
    public function setPackageIDBarcodeIndicator($packageIDBarcodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($packageIDBarcodeIndicator) && !is_string($packageIDBarcodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIDBarcodeIndicator, true), gettype($packageIDBarcodeIndicator)), __LINE__);
        }
        $this->PackageIDBarcodeIndicator = $packageIDBarcodeIndicator;
        return $this;
    }
    /**
     * Get IrregularIndicator value
     * @return string|null
     */
    public function getIrregularIndicator()
    {
        return $this->IrregularIndicator;
    }
    /**
     * Set IrregularIndicator value
     * @param string $irregularIndicator
     * @return \StructType\ShipmentType
     */
    public function setIrregularIndicator($irregularIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($irregularIndicator) && !is_string($irregularIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($irregularIndicator, true), gettype($irregularIndicator)), __LINE__);
        }
        $this->IrregularIndicator = $irregularIndicator;
        return $this;
    }
    /**
     * Get ShipmentIndicationType value
     * @return \StructType\IndicationType[]|null
     */
    public function getShipmentIndicationType()
    {
        return $this->ShipmentIndicationType;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentIndicationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentIndicationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentIndicationTypeItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentIndicationTypeItem instanceof \StructType\IndicationType) {
                $invalidValues[] = is_object($shipmentTypeShipmentIndicationTypeItem) ? get_class($shipmentTypeShipmentIndicationTypeItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentIndicationTypeItem), var_export($shipmentTypeShipmentIndicationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentIndicationType property can only contain items of type \StructType\IndicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \StructType\IndicationType[] $shipmentIndicationType
     * @return \StructType\ShipmentType
     */
    public function setShipmentIndicationType(array $shipmentIndicationType = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentIndicationTypeArrayErrorMessage = self::validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType($shipmentIndicationType))) {
            throw new \InvalidArgumentException($shipmentIndicationTypeArrayErrorMessage, __LINE__);
        }
        $this->ShipmentIndicationType = $shipmentIndicationType;
        return $this;
    }
    /**
     * Add item to ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \StructType\IndicationType $item
     * @return \StructType\ShipmentType
     */
    public function addToShipmentIndicationType(\StructType\IndicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IndicationType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentIndicationType property can only contain items of type \StructType\IndicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentIndicationType[] = $item;
        return $this;
    }
    /**
     * Get MIDualReturnShipmentKey value
     * @return string|null
     */
    public function getMIDualReturnShipmentKey()
    {
        return $this->MIDualReturnShipmentKey;
    }
    /**
     * Set MIDualReturnShipmentKey value
     * @param string $mIDualReturnShipmentKey
     * @return \StructType\ShipmentType
     */
    public function setMIDualReturnShipmentKey($mIDualReturnShipmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($mIDualReturnShipmentKey) && !is_string($mIDualReturnShipmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIDualReturnShipmentKey, true), gettype($mIDualReturnShipmentKey)), __LINE__);
        }
        $this->MIDualReturnShipmentKey = $mIDualReturnShipmentKey;
        return $this;
    }
    /**
     * Get MIDualReturnShipmentIndicator value
     * @return string|null
     */
    public function getMIDualReturnShipmentIndicator()
    {
        return $this->MIDualReturnShipmentIndicator;
    }
    /**
     * Set MIDualReturnShipmentIndicator value
     * @param string $mIDualReturnShipmentIndicator
     * @return \StructType\ShipmentType
     */
    public function setMIDualReturnShipmentIndicator($mIDualReturnShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($mIDualReturnShipmentIndicator) && !is_string($mIDualReturnShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIDualReturnShipmentIndicator, true), gettype($mIDualReturnShipmentIndicator)), __LINE__);
        }
        $this->MIDualReturnShipmentIndicator = $mIDualReturnShipmentIndicator;
        return $this;
    }
    /**
     * Get RatingMethodRequestedIndicator value
     * @return string|null
     */
    public function getRatingMethodRequestedIndicator()
    {
        return $this->RatingMethodRequestedIndicator;
    }
    /**
     * Set RatingMethodRequestedIndicator value
     * @param string $ratingMethodRequestedIndicator
     * @return \StructType\ShipmentType
     */
    public function setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($ratingMethodRequestedIndicator) && !is_string($ratingMethodRequestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingMethodRequestedIndicator, true), gettype($ratingMethodRequestedIndicator)), __LINE__);
        }
        $this->RatingMethodRequestedIndicator = $ratingMethodRequestedIndicator;
        return $this;
    }
    /**
     * Get TaxInformationIndicator value
     * @return string|null
     */
    public function getTaxInformationIndicator()
    {
        return $this->TaxInformationIndicator;
    }
    /**
     * Set TaxInformationIndicator value
     * @param string $taxInformationIndicator
     * @return \StructType\ShipmentType
     */
    public function setTaxInformationIndicator($taxInformationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($taxInformationIndicator) && !is_string($taxInformationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxInformationIndicator, true), gettype($taxInformationIndicator)), __LINE__);
        }
        $this->TaxInformationIndicator = $taxInformationIndicator;
        return $this;
    }
    /**
     * Get PromotionalDiscountInformation value
     * @return \StructType\PromotionalDiscountInformationType|null
     */
    public function getPromotionalDiscountInformation()
    {
        return $this->PromotionalDiscountInformation;
    }
    /**
     * Set PromotionalDiscountInformation value
     * @param \StructType\PromotionalDiscountInformationType $promotionalDiscountInformation
     * @return \StructType\ShipmentType
     */
    public function setPromotionalDiscountInformation(\StructType\PromotionalDiscountInformationType $promotionalDiscountInformation = null)
    {
        $this->PromotionalDiscountInformation = $promotionalDiscountInformation;
        return $this;
    }
    /**
     * Get DGSignatoryInfo value
     * @return \StructType\DGSignatoryInfoType|null
     */
    public function getDGSignatoryInfo()
    {
        return $this->DGSignatoryInfo;
    }
    /**
     * Set DGSignatoryInfo value
     * @param \StructType\DGSignatoryInfoType $dGSignatoryInfo
     * @return \StructType\ShipmentType
     */
    public function setDGSignatoryInfo(\StructType\DGSignatoryInfoType $dGSignatoryInfo = null)
    {
        $this->DGSignatoryInfo = $dGSignatoryInfo;
        return $this;
    }
    /**
     * Get MasterCartonID value
     * @return string|null
     */
    public function getMasterCartonID()
    {
        return $this->MasterCartonID;
    }
    /**
     * Set MasterCartonID value
     * @param string $masterCartonID
     * @return \StructType\ShipmentType
     */
    public function setMasterCartonID($masterCartonID = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonID) && !is_string($masterCartonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonID, true), gettype($masterCartonID)), __LINE__);
        }
        $this->MasterCartonID = $masterCartonID;
        return $this;
    }
    /**
     * Get MasterCartonIndicator value
     * @return string|null
     */
    public function getMasterCartonIndicator()
    {
        return $this->MasterCartonIndicator;
    }
    /**
     * Set MasterCartonIndicator value
     * @param string $masterCartonIndicator
     * @return \StructType\ShipmentType
     */
    public function setMasterCartonIndicator($masterCartonIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonIndicator) && !is_string($masterCartonIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonIndicator, true), gettype($masterCartonIndicator)), __LINE__);
        }
        $this->MasterCartonIndicator = $masterCartonIndicator;
        return $this;
    }
    /**
     * Get DeniedPartyScreeningIndicator value
     * @return string|null
     */
    public function getDeniedPartyScreeningIndicator()
    {
        return $this->DeniedPartyScreeningIndicator;
    }
    /**
     * Set DeniedPartyScreeningIndicator value
     * @param string $deniedPartyScreeningIndicator
     * @return \StructType\ShipmentType
     */
    public function setDeniedPartyScreeningIndicator($deniedPartyScreeningIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deniedPartyScreeningIndicator) && !is_string($deniedPartyScreeningIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deniedPartyScreeningIndicator, true), gettype($deniedPartyScreeningIndicator)), __LINE__);
        }
        $this->DeniedPartyScreeningIndicator = $deniedPartyScreeningIndicator;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\ShipmentType
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get ShipmentValueThresholdCode value
     * @return string|null
     */
    public function getShipmentValueThresholdCode()
    {
        return $this->ShipmentValueThresholdCode;
    }
    /**
     * Set ShipmentValueThresholdCode value
     * @param string $shipmentValueThresholdCode
     * @return \StructType\ShipmentType
     */
    public function setShipmentValueThresholdCode($shipmentValueThresholdCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentValueThresholdCode) && !is_string($shipmentValueThresholdCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentValueThresholdCode, true), gettype($shipmentValueThresholdCode)), __LINE__);
        }
        $this->ShipmentValueThresholdCode = $shipmentValueThresholdCode;
        return $this;
    }
    /**
     * Get ShipmentServiceOptions value
     * @return \StructType\ShipmentServiceOptions|null
     */
    public function getShipmentServiceOptions()
    {
        return $this->ShipmentServiceOptions;
    }
    /**
     * Set ShipmentServiceOptions value
     * @param \StructType\ShipmentServiceOptions $shipmentServiceOptions
     * @return \StructType\ShipmentType
     */
    public function setShipmentServiceOptions(\StructType\ShipmentServiceOptions $shipmentServiceOptions = null)
    {
        $this->ShipmentServiceOptions = $shipmentServiceOptions;
        return $this;
    }
    /**
     * Get Package value
     * @return \StructType\PackageType[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypePackageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypePackageItem instanceof \StructType\PackageType) {
                $invalidValues[] = is_object($shipmentTypePackageItem) ? get_class($shipmentTypePackageItem) : sprintf('%s(%s)', gettype($shipmentTypePackageItem), var_export($shipmentTypePackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageType[] $package
     * @return \StructType\ShipmentType
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageType $item
     * @return \StructType\ShipmentType
     */
    public function addToPackage(\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
}
