<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentChargesType StructType
 * @subpackage Structs
 */
class ShipmentChargesType extends AbstractStructBase
{
    /**
     * The RateChart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChart;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The TransportationCharges
     * @var \StructType\ShipChargeType
     */
    public $TransportationCharges;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The ServiceOptionsCharges
     * @var \StructType\ShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharges
     * @var \StructType\ShipChargeType
     */
    public $TotalCharges;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipChargeType
     */
    public $TotalChargesWithTaxes;
    /**
     * The EstimatedDutiesAndTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EstimatedDutiesAndTaxesType
     */
    public $EstimatedDutiesAndTaxes;
    /**
     * Constructor method for ShipmentChargesType
     * @uses ShipmentChargesType::setRateChart()
     * @uses ShipmentChargesType::setBaseServiceCharge()
     * @uses ShipmentChargesType::setTransportationCharges()
     * @uses ShipmentChargesType::setItemizedCharges()
     * @uses ShipmentChargesType::setServiceOptionsCharges()
     * @uses ShipmentChargesType::setTaxCharges()
     * @uses ShipmentChargesType::setTotalCharges()
     * @uses ShipmentChargesType::setTotalChargesWithTaxes()
     * @uses ShipmentChargesType::setEstimatedDutiesAndTaxes()
     * @param string $rateChart
     * @param \StructType\ShipChargeType $baseServiceCharge
     * @param \StructType\ShipChargeType $transportationCharges
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @param \StructType\ShipChargeType $serviceOptionsCharges
     * @param \StructType\TaxChargeType[] $taxCharges
     * @param \StructType\ShipChargeType $totalCharges
     * @param \StructType\ShipChargeType $totalChargesWithTaxes
     * @param \StructType\EstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes
     */
    public function __construct($rateChart = null, \StructType\ShipChargeType $baseServiceCharge = null, \StructType\ShipChargeType $transportationCharges = null, array $itemizedCharges = array(), \StructType\ShipChargeType $serviceOptionsCharges = null, array $taxCharges = array(), \StructType\ShipChargeType $totalCharges = null, \StructType\ShipChargeType $totalChargesWithTaxes = null, \StructType\EstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes = null)
    {
        $this
            ->setRateChart($rateChart)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setTransportationCharges($transportationCharges)
            ->setItemizedCharges($itemizedCharges)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharges($totalCharges)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes)
            ->setEstimatedDutiesAndTaxes($estimatedDutiesAndTaxes);
    }
    /**
     * Get RateChart value
     * @return string|null
     */
    public function getRateChart()
    {
        return $this->RateChart;
    }
    /**
     * Set RateChart value
     * @param string $rateChart
     * @return \StructType\ShipmentChargesType
     */
    public function setRateChart($rateChart = null)
    {
        // validation for constraint: string
        if (!is_null($rateChart) && !is_string($rateChart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChart, true), gettype($rateChart)), __LINE__);
        }
        $this->RateChart = $rateChart;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \StructType\ShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \StructType\ShipChargeType $baseServiceCharge
     * @return \StructType\ShipmentChargesType
     */
    public function setBaseServiceCharge(\StructType\ShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get TransportationCharges value
     * @return \StructType\ShipChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \StructType\ShipChargeType $transportationCharges
     * @return \StructType\ShipmentChargesType
     */
    public function setTransportationCharges(\StructType\ShipChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \StructType\ShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeItemizedChargesItem instanceof \StructType\ShipChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeItemizedChargesItem) ? get_class($shipmentChargesTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeItemizedChargesItem), var_export($shipmentChargesTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType[] $itemizedCharges
     * @return \StructType\ShipmentChargesType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipChargeType $item
     * @return \StructType\ShipmentChargesType
     */
    public function addToItemizedCharges(\StructType\ShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \StructType\ShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \StructType\ShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \StructType\ShipChargeType $serviceOptionsCharges
     * @return \StructType\ShipmentChargesType
     */
    public function setServiceOptionsCharges(\StructType\ShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \StructType\TaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeTaxChargesItem instanceof \StructType\TaxChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeTaxChargesItem) ? get_class($shipmentChargesTypeTaxChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeTaxChargesItem), var_export($shipmentChargesTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \StructType\TaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxChargeType[] $taxCharges
     * @return \StructType\ShipmentChargesType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxChargeType $item
     * @return \StructType\ShipmentChargesType
     */
    public function addToTaxCharges(\StructType\TaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \StructType\TaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return \StructType\ShipChargeType|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param \StructType\ShipChargeType $totalCharges
     * @return \StructType\ShipmentChargesType
     */
    public function setTotalCharges(\StructType\ShipChargeType $totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \StructType\ShipChargeType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \StructType\ShipChargeType $totalChargesWithTaxes
     * @return \StructType\ShipmentChargesType
     */
    public function setTotalChargesWithTaxes(\StructType\ShipChargeType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
    /**
     * Get EstimatedDutiesAndTaxes value
     * @return \StructType\EstimatedDutiesAndTaxesType|null
     */
    public function getEstimatedDutiesAndTaxes()
    {
        return $this->EstimatedDutiesAndTaxes;
    }
    /**
     * Set EstimatedDutiesAndTaxes value
     * @param \StructType\EstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes
     * @return \StructType\ShipmentChargesType
     */
    public function setEstimatedDutiesAndTaxes(\StructType\EstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes = null)
    {
        $this->EstimatedDutiesAndTaxes = $estimatedDutiesAndTaxes;
        return $this;
    }
}
