<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType StructType
 * @subpackage Structs
 */
class ResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \StructType\CodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses ResponseType::setResponseStatus()
     * @uses ResponseType::setAlert()
     * @uses ResponseType::setAlertDetail()
     * @uses ResponseType::setTransactionReference()
     * @param \StructType\CodeDescriptionType $responseStatus
     * @param \StructType\CodeDescriptionType[] $alert
     * @param \StructType\DetailType[] $alertDetail
     * @param \StructType\TransactionReferenceType $transactionReference
     */
    public function __construct(\StructType\CodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \StructType\TransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \StructType\CodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \StructType\CodeDescriptionType $responseStatus
     * @return \StructType\ResponseType
     */
    public function setResponseStatus(\StructType\CodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \StructType\CodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \StructType\CodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \StructType\CodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeDescriptionType[] $alert
     * @return \StructType\ResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeDescriptionType $item
     * @return \StructType\ResponseType
     */
    public function addToAlert(\StructType\CodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \StructType\CodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \StructType\DetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \StructType\DetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \StructType\DetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailType[] $alertDetail
     * @return \StructType\ResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailType $item
     * @return \StructType\ResponseType
     */
    public function addToAlertDetail(\StructType\DetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \StructType\DetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \StructType\TransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \StructType\TransactionReferenceType $transactionReference
     * @return \StructType\ResponseType
     */
    public function setTransactionReference(\StructType\TransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
