<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateInfoType StructType
 * @subpackage Structs
 */
class RateInfoType extends AbstractStructBase
{
    /**
     * The NegotiatedRatesIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NegotiatedRatesIndicator;
    /**
     * The FRSShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FRSShipmentIndicator;
    /**
     * The RateChartIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChartIndicator;
    /**
     * The TPFCNegotiatedRatesIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TPFCNegotiatedRatesIndicator;
    /**
     * The UserLevelDiscountIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLevelDiscountIndicator;
    /**
     * Constructor method for RateInfoType
     * @uses RateInfoType::setNegotiatedRatesIndicator()
     * @uses RateInfoType::setFRSShipmentIndicator()
     * @uses RateInfoType::setRateChartIndicator()
     * @uses RateInfoType::setTPFCNegotiatedRatesIndicator()
     * @uses RateInfoType::setUserLevelDiscountIndicator()
     * @param string $negotiatedRatesIndicator
     * @param string $fRSShipmentIndicator
     * @param string $rateChartIndicator
     * @param string $tPFCNegotiatedRatesIndicator
     * @param string $userLevelDiscountIndicator
     */
    public function __construct($negotiatedRatesIndicator = null, $fRSShipmentIndicator = null, $rateChartIndicator = null, $tPFCNegotiatedRatesIndicator = null, $userLevelDiscountIndicator = null)
    {
        $this
            ->setNegotiatedRatesIndicator($negotiatedRatesIndicator)
            ->setFRSShipmentIndicator($fRSShipmentIndicator)
            ->setRateChartIndicator($rateChartIndicator)
            ->setTPFCNegotiatedRatesIndicator($tPFCNegotiatedRatesIndicator)
            ->setUserLevelDiscountIndicator($userLevelDiscountIndicator);
    }
    /**
     * Get NegotiatedRatesIndicator value
     * @return string|null
     */
    public function getNegotiatedRatesIndicator()
    {
        return $this->NegotiatedRatesIndicator;
    }
    /**
     * Set NegotiatedRatesIndicator value
     * @param string $negotiatedRatesIndicator
     * @return \StructType\RateInfoType
     */
    public function setNegotiatedRatesIndicator($negotiatedRatesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($negotiatedRatesIndicator) && !is_string($negotiatedRatesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($negotiatedRatesIndicator, true), gettype($negotiatedRatesIndicator)), __LINE__);
        }
        $this->NegotiatedRatesIndicator = $negotiatedRatesIndicator;
        return $this;
    }
    /**
     * Get FRSShipmentIndicator value
     * @return string|null
     */
    public function getFRSShipmentIndicator()
    {
        return $this->FRSShipmentIndicator;
    }
    /**
     * Set FRSShipmentIndicator value
     * @param string $fRSShipmentIndicator
     * @return \StructType\RateInfoType
     */
    public function setFRSShipmentIndicator($fRSShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($fRSShipmentIndicator) && !is_string($fRSShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fRSShipmentIndicator, true), gettype($fRSShipmentIndicator)), __LINE__);
        }
        $this->FRSShipmentIndicator = $fRSShipmentIndicator;
        return $this;
    }
    /**
     * Get RateChartIndicator value
     * @return string|null
     */
    public function getRateChartIndicator()
    {
        return $this->RateChartIndicator;
    }
    /**
     * Set RateChartIndicator value
     * @param string $rateChartIndicator
     * @return \StructType\RateInfoType
     */
    public function setRateChartIndicator($rateChartIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($rateChartIndicator) && !is_string($rateChartIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChartIndicator, true), gettype($rateChartIndicator)), __LINE__);
        }
        $this->RateChartIndicator = $rateChartIndicator;
        return $this;
    }
    /**
     * Get TPFCNegotiatedRatesIndicator value
     * @return string|null
     */
    public function getTPFCNegotiatedRatesIndicator()
    {
        return $this->TPFCNegotiatedRatesIndicator;
    }
    /**
     * Set TPFCNegotiatedRatesIndicator value
     * @param string $tPFCNegotiatedRatesIndicator
     * @return \StructType\RateInfoType
     */
    public function setTPFCNegotiatedRatesIndicator($tPFCNegotiatedRatesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($tPFCNegotiatedRatesIndicator) && !is_string($tPFCNegotiatedRatesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tPFCNegotiatedRatesIndicator, true), gettype($tPFCNegotiatedRatesIndicator)), __LINE__);
        }
        $this->TPFCNegotiatedRatesIndicator = $tPFCNegotiatedRatesIndicator;
        return $this;
    }
    /**
     * Get UserLevelDiscountIndicator value
     * @return string|null
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->UserLevelDiscountIndicator;
    }
    /**
     * Set UserLevelDiscountIndicator value
     * @param string $userLevelDiscountIndicator
     * @return \StructType\RateInfoType
     */
    public function setUserLevelDiscountIndicator($userLevelDiscountIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($userLevelDiscountIndicator) && !is_string($userLevelDiscountIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLevelDiscountIndicator, true), gettype($userLevelDiscountIndicator)), __LINE__);
        }
        $this->UserLevelDiscountIndicator = $userLevelDiscountIndicator;
        return $this;
    }
}
