<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageDeclaredValueType StructType
 * @subpackage Structs
 */
class PackageDeclaredValueType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeclaredValueType
     */
    public $Type;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * Constructor method for PackageDeclaredValueType
     * @uses PackageDeclaredValueType::setType()
     * @uses PackageDeclaredValueType::setCurrencyCode()
     * @uses PackageDeclaredValueType::setMonetaryValue()
     * @param \StructType\DeclaredValueType $type
     * @param string $currencyCode
     * @param string $monetaryValue
     */
    public function __construct(\StructType\DeclaredValueType $type = null, $currencyCode = null, $monetaryValue = null)
    {
        $this
            ->setType($type)
            ->setCurrencyCode($currencyCode)
            ->setMonetaryValue($monetaryValue);
    }
    /**
     * Get Type value
     * @return \StructType\DeclaredValueType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\DeclaredValueType $type
     * @return \StructType\PackageDeclaredValueType
     */
    public function setType(\StructType\DeclaredValueType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\PackageDeclaredValueType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \StructType\PackageDeclaredValueType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
}
