<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType StructType
 * @subpackage Structs
 */
class ErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \StructType\CodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses ErrorDetailType::setSeverity()
     * @uses ErrorDetailType::setPrimaryErrorCode()
     * @uses ErrorDetailType::setMinimumRetrySeconds()
     * @uses ErrorDetailType::setLocation()
     * @uses ErrorDetailType::setSubErrorCode()
     * @uses ErrorDetailType::setAdditionalInformation()
     * @uses ErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \StructType\CodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \StructType\LocationType $location
     * @param \StructType\CodeType[] $subErrorCode
     * @param \StructType\AdditionalInfoType[] $additionalInformation
     * @param \StructType\ElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \StructType\CodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \StructType\LocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \StructType\ElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \StructType\ErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \StructType\CodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \StructType\CodeType $primaryErrorCode
     * @return \StructType\ErrorDetailType
     */
    public function setPrimaryErrorCode(\StructType\CodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \StructType\ErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationType $location
     * @return \StructType\ErrorDetailType
     */
    public function setLocation(\StructType\LocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \StructType\CodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \StructType\CodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \StructType\CodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeType[] $subErrorCode
     * @return \StructType\ErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeType $item
     * @return \StructType\ErrorDetailType
     */
    public function addToSubErrorCode(\StructType\CodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \StructType\CodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \StructType\AdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \StructType\AdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \StructType\AdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInfoType[] $additionalInformation
     * @return \StructType\ErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInfoType $item
     * @return \StructType\ErrorDetailType
     */
    public function addToAdditionalInformation(\StructType\AdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \StructType\AdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \StructType\ElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \StructType\ElementLevelInformationType $elementLevelInformation
     * @return \StructType\ErrorDetailType
     */
    public function setElementLevelInformation(\StructType\ElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
