<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EEILicenseType StructType
 * @subpackage Structs
 */
class EEILicenseType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The LicenseLineValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LicenseLineValue;
    /**
     * The ECCNNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ECCNNumber;
    /**
     * Constructor method for EEILicenseType
     * @uses EEILicenseType::setNumber()
     * @uses EEILicenseType::setCode()
     * @uses EEILicenseType::setLicenseLineValue()
     * @uses EEILicenseType::setECCNNumber()
     * @param string $number
     * @param string $code
     * @param string $licenseLineValue
     * @param string $eCCNNumber
     */
    public function __construct($number = null, $code = null, $licenseLineValue = null, $eCCNNumber = null)
    {
        $this
            ->setNumber($number)
            ->setCode($code)
            ->setLicenseLineValue($licenseLineValue)
            ->setECCNNumber($eCCNNumber);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\EEILicenseType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\EEILicenseType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LicenseLineValue value
     * @return string|null
     */
    public function getLicenseLineValue()
    {
        return $this->LicenseLineValue;
    }
    /**
     * Set LicenseLineValue value
     * @param string $licenseLineValue
     * @return \StructType\EEILicenseType
     */
    public function setLicenseLineValue($licenseLineValue = null)
    {
        // validation for constraint: string
        if (!is_null($licenseLineValue) && !is_string($licenseLineValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseLineValue, true), gettype($licenseLineValue)), __LINE__);
        }
        $this->LicenseLineValue = $licenseLineValue;
        return $this;
    }
    /**
     * Get ECCNNumber value
     * @return string|null
     */
    public function getECCNNumber()
    {
        return $this->ECCNNumber;
    }
    /**
     * Set ECCNNumber value
     * @param string $eCCNNumber
     * @return \StructType\EEILicenseType
     */
    public function setECCNNumber($eCCNNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCCNNumber) && !is_string($eCCNNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCCNNumber, true), gettype($eCCNNumber)), __LINE__);
        }
        $this->ECCNNumber = $eCCNNumber;
        return $this;
    }
}
