<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillReceiverType StructType
 * @subpackage Structs
 */
class BillReceiverType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillReceiverAddressType
     */
    public $Address;
    /**
     * Constructor method for BillReceiverType
     * @uses BillReceiverType::setAccountNumber()
     * @uses BillReceiverType::setAddress()
     * @param string $accountNumber
     * @param \StructType\BillReceiverAddressType $address
     */
    public function __construct($accountNumber = null, \StructType\BillReceiverAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BillReceiverType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\BillReceiverAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\BillReceiverAddressType $address
     * @return \StructType\BillReceiverType
     */
    public function setAddress(\StructType\BillReceiverAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
