<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInfoType StructType
 * @subpackage Structs
 */
class AdditionalInfoType extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AdditionalCodeDescType[]
     */
    public $Value;
    /**
     * Constructor method for AdditionalInfoType
     * @uses AdditionalInfoType::setType()
     * @uses AdditionalInfoType::setValue()
     * @param string $type
     * @param \StructType\AdditionalCodeDescType[] $value
     */
    public function __construct($type = null, array $value = array())
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AdditionalInfoType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\AdditionalCodeDescType[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalInfoTypeValueItem) {
            // validation for constraint: itemType
            if (!$additionalInfoTypeValueItem instanceof \StructType\AdditionalCodeDescType) {
                $invalidValues[] = is_object($additionalInfoTypeValueItem) ? get_class($additionalInfoTypeValueItem) : sprintf('%s(%s)', gettype($additionalInfoTypeValueItem), var_export($additionalInfoTypeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \StructType\AdditionalCodeDescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCodeDescType[] $value
     * @return \StructType\AdditionalInfoType
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCodeDescType $item
     * @return \StructType\AdditionalInfoType
     */
    public function addToValue(\StructType\AdditionalCodeDescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalCodeDescType) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type \StructType\AdditionalCodeDescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
