<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExchangeRatesRequestBody StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetExchangeRatesRequestBody
 * @subpackage Structs
 */
class GetExchangeRatesRequestBody extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $endDate;
    /**
     * The currencyNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currencyNames;
    /**
     * Constructor method for GetExchangeRatesRequestBody
     * @uses GetExchangeRatesRequestBody::setStartDate()
     * @uses GetExchangeRatesRequestBody::setEndDate()
     * @uses GetExchangeRatesRequestBody::setCurrencyNames()
     * @param string $startDate
     * @param string $endDate
     * @param string $currencyNames
     */
    public function __construct($startDate = null, $endDate = null, $currencyNames = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCurrencyNames($currencyNames);
    }
    /**
     * Get startDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->startDate) ? $this->startDate : null;
    }
    /**
     * Set startDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \StructType\GetExchangeRatesRequestBody
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->startDate);
        } else {
            $this->startDate = $startDate;
        }
        return $this;
    }
    /**
     * Get endDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->endDate) ? $this->endDate : null;
    }
    /**
     * Set endDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \StructType\GetExchangeRatesRequestBody
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->endDate);
        } else {
            $this->endDate = $endDate;
        }
        return $this;
    }
    /**
     * Get currencyNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyNames()
    {
        return isset($this->currencyNames) ? $this->currencyNames : null;
    }
    /**
     * Set currencyNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyNames
     * @return \StructType\GetExchangeRatesRequestBody
     */
    public function setCurrencyNames($currencyNames = null)
    {
        // validation for constraint: string
        if (!is_null($currencyNames) && !is_string($currencyNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyNames, true), gettype($currencyNames)), __LINE__);
        }
        if (is_null($currencyNames) || (is_array($currencyNames) && empty($currencyNames))) {
            unset($this->currencyNames);
        } else {
            $this->currencyNames = $currencyNames;
        }
        return $this;
    }
}
