<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserCreatedFormType StructType
 * @subpackage Structs
 */
class UserCreatedFormType extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $DocumentID;
    /**
     * Constructor method for UserCreatedFormType
     * @uses UserCreatedFormType::setDocumentID()
     * @param string[] $documentID
     */
    public function __construct(array $documentID = array())
    {
        $this
            ->setDocumentID($documentID);
    }
    /**
     * Get DocumentID value
     * @return string[]|null
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentIDForArrayConstraintsFromSetDocumentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userCreatedFormTypeDocumentIDItem) {
            // validation for constraint: itemType
            if (!is_string($userCreatedFormTypeDocumentIDItem)) {
                $invalidValues[] = is_object($userCreatedFormTypeDocumentIDItem) ? get_class($userCreatedFormTypeDocumentIDItem) : sprintf('%s(%s)', gettype($userCreatedFormTypeDocumentIDItem), var_export($userCreatedFormTypeDocumentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentID value
     * @throws \InvalidArgumentException
     * @param string[] $documentID
     * @return \StructType\UserCreatedFormType
     */
    public function setDocumentID(array $documentID = array())
    {
        // validation for constraint: array
        if ('' !== ($documentIDArrayErrorMessage = self::validateDocumentIDForArrayConstraintsFromSetDocumentID($documentID))) {
            throw new \InvalidArgumentException($documentIDArrayErrorMessage, __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Add item to DocumentID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UserCreatedFormType
     */
    public function addToDocumentID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocumentID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentID[] = $item;
        return $this;
    }
}
